/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XWikiDocument {
    private String name;
    private String space;
    private String language;
    private String defaultLanguage;
    private String creator;
    private String author;
    private String contentAuthor;
    private String version;
    private String parent;
    private String comment;
    private String minorEdit;
    private String encoding;

    public void fromXML(File file) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        this.encoding = domdoc.getXMLEncoding();
        Element rootElement = domdoc.getRootElement();
        this.name = this.readElement(rootElement, "name");
        this.space = this.readElement(rootElement, "web");
        this.language = this.readElement(rootElement, "language");
        this.defaultLanguage = this.readElement(rootElement, "defaultLanguage");
        this.creator = this.readElement(rootElement, "creator");
        this.author = this.readElement(rootElement, "author");
        this.contentAuthor = this.readElement(rootElement, "contentAuthor");
        this.version = this.readElement(rootElement, "version");
        this.parent = this.readElement(rootElement, "parent");
        this.comment = this.readElement(rootElement, "comment");
        this.minorEdit = this.readElement(rootElement, "minorEdit");
    }

    private String readElement(Element rootElement, String elementName) {
        String result = null;
        Element element = rootElement.element(elementName);
        if (element != null) {
            result = element.getText();
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContentAuthor() {
        return this.contentAuthor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getParent() {
        return this.parent;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMinorEdit() {
        return this.minorEdit;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        return this.space == null ? this.name : this.escapeSpaceOrPageName(this.space) + '.' + this.escapeSpaceOrPageName(this.name);
    }

    private String escapeSpaceOrPageName(String name) {
        return name != null ? name.replaceAll("[\\\\\\.]", "\\\\$0") : null;
    }

    public static String getFullName(File file) {
        XWikiDocument doc;
        try {
            doc = new XWikiDocument();
            doc.fromXML(file);
        }
        catch (Exception e) {
            return null;
        }
        return doc.getFullName();
    }
}

