/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.XWikiXMLWriter;

public class FormatMojo
extends AbstractVerifyMojo {
    private boolean pretty = true;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getPackaging().equals("xar") || this.force) {
            this.getLog().info((CharSequence)"Formatting XAR XML files...");
            for (File file : this.getXARXMLFiles()) {
                try {
                    this.format(file);
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("Failed to format file [%s]", file), e);
                }
            }
        } else {
            this.getLog().info((CharSequence)"Not a XAR module, skipping reformatting...");
        }
    }

    private void format(File file) throws Exception {
        XWikiXMLWriter writer;
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(file);
        Node node = domdoc.selectSingleNode("xwikidoc/author");
        node.setText("xwiki:XWiki.Admin");
        node = domdoc.selectSingleNode("xwikidoc/contentAuthor");
        node.setText("xwiki:XWiki.Admin");
        node = domdoc.selectSingleNode("xwikidoc/creator");
        node.setText("xwiki:XWiki.Admin");
        node = domdoc.selectSingleNode("xwikidoc/version");
        node.setText("1.1");
        node = domdoc.selectSingleNode("xwikidoc/minorEdit");
        node.setText("false");
        Element element = (Element)domdoc.selectSingleNode("xwikidoc/defaultLanguage");
        this.removeContent(element);
        element = (Element)domdoc.selectSingleNode("xwikidoc/comment");
        this.removeContent(element);
        if (this.pretty) {
            OutputFormat format = new OutputFormat("  ", true, "UTF-8");
            format.setExpandEmptyElements(false);
            writer = new XWikiXMLWriter(new FileOutputStream(file), format);
        } else {
            writer = new XWikiXMLWriter(new FileOutputStream(file));
        }
        writer.write(domdoc);
        writer.close();
        String parentName = file.getParentFile().getName();
        this.getLog().info((CharSequence)String.format("  Formatting [%s/%s]... ok", parentName, file.getName()));
    }

    private void removeContent(Element element) {
        if (element.hasContent()) {
            ((Node)element.content().get(0)).detach();
        }
    }
}

