/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.tool.xar;

/**
 * Properties to apply to a XAR entry.
 * 
 * @version $Id: ba8b01cc62f84b8a1387e4d887809c3e1fb9f097 $
 * @since 10.3
 */
public class XAREntry
{
    private String document;

    private String type;

    /**
     * @return the document name
     */
    public String getDocument()
    {
        return document;
    }

    /**
     * @param document the document name
     */
    public void setDocument(String document)
    {
        this.document = document;
    }

    /**
     * @return the document type
     */
    public String getType()
    {
        return type;
    }

    /**
     * @param type the document type
     */
    public void setType(String type)
    {
        this.type = type;
    }
}
