/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.xwiki.tool.xar.AbstractXARMojo;
import org.xwiki.tool.xar.Transformation;
import org.xwiki.tool.xar.XAREntry;
import org.xwiki.tool.xar.internal.XWikiDocument;

@Mojo(name="xar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class XARMojo
extends AbstractXARMojo {
    @Parameter(property="xar.includeDependencies", defaultValue="false")
    private boolean includeDependencies;
    @Parameter(property="defaultEntryType", readonly=true, required=false)
    private String defaultEntryType;
    @Parameter
    private List<Transformation> transformations;

    public void execute() throws MojoExecutionException {
        if (this.project.getResources().isEmpty()) {
            this.getLog().warn((CharSequence)"No XAR created as no resources were found");
            return;
        }
        try {
            this.performArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while creating XAR file", e);
        }
    }

    private void performArchive() throws Exception {
        File sourceDir = new File(this.project.getBuild().getOutputDirectory());
        if (sourceDir.listFiles() == null) {
            throw new Exception(String.format("No XAR XML files found in [%s]. Has the Maven Resource plugin be called?", sourceDir));
        }
        File xarFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + ".xar");
        ZipArchiver archiver = new ZipArchiver();
        archiver.setEncoding(this.encoding);
        archiver.setDestFile(xarFile);
        archiver.setIncludeEmptyDirs(false);
        archiver.setCompress(true);
        if (this.includeDependencies) {
            this.unpackDependentXARs();
        }
        this.performTransformations();
        File resourcesDir = this.getResourcesDirectory();
        if (!this.hasPackageXmlFile(resourcesDir)) {
            this.addFilesToArchive(archiver, sourceDir);
        } else {
            File packageXml = new File(resourcesDir, "package.xml");
            this.addFilesToArchive(archiver, sourceDir, packageXml);
        }
        archiver.createArchive();
        this.project.getArtifact().setFile(xarFile);
    }

    private boolean hasPackageXmlFile(File resourcesDir) throws MojoExecutionException {
        if (!resourcesDir.exists()) {
            return false;
        }
        FilenameFilter packageXmlFiler = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("package.xml");
            }
        };
        String[] fileNames = resourcesDir.list(packageXmlFiler);
        if (fileNames == null) {
            throw new MojoExecutionException(String.format("Couldn't get list of files in resources dir [%s]", resourcesDir));
        }
        return fileNames.length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTransformations() throws Exception {
        if (this.transformations == null) {
            return;
        }
        this.unpackTransformedXARs();
        SAXReader reader = new SAXReader();
        for (Transformation transformation : this.transformations) {
            File file = new File(this.project.getBuild().getOutputDirectory(), transformation.getFile());
            Document document = reader.read(file);
            Node node = document.selectSingleNode(transformation.getXpath());
            if (node != null) {
                String value = transformation.getValue();
                if (value != null) {
                    String currentValue = node.getText();
                    node.setText(value.replace("$1", currentValue));
                } else if (transformation.getAction() != null) {
                    Document xmlDocument = null;
                    Element xmlElement = null;
                    File content = null;
                    if (transformation.getXml() != null) {
                        xmlDocument = reader.read(transformation.getXml());
                        xmlElement = xmlDocument.getRootElement();
                    } else if (transformation.getContent() != null) {
                        content = transformation.getContent();
                    }
                    switch (transformation.getAction()) {
                        case INSERT_CHILD: {
                            ((Element)node).add(xmlElement);
                            break;
                        }
                        case REPLACE: {
                            Element parent = node.getParent();
                            if (parent == null) {
                                document = xmlDocument;
                                break;
                            }
                            List siblings = parent.elements();
                            siblings.set(parent.indexOf(node), xmlElement);
                            break;
                        }
                        case INSERT_ATTACHMENT_CONTENT: {
                            if (content == null) break;
                            node.selectSingleNode("filesize").setText(Long.toString(content.length(), 10));
                            node.selectSingleNode("content").setText("\r\n" + new String(Base64.getMimeEncoder().encode(FileUtils.readFileToByteArray((File)content))) + "\r\n");
                            break;
                        }
                        case INSERT_TEXT: {
                            if (content == null) break;
                            node.setText(FileUtils.readFileToString((File)content, (Charset)Charset.forName(transformation.getCharset())));
                            break;
                        }
                        case REMOVE: {
                            node.getParent().remove(node);
                            break;
                        }
                    }
                }
                XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(file));
                try {
                    writer.write(document);
                    writer.flush();
                    continue;
                }
                finally {
                    writer.close();
                    continue;
                }
            }
            this.getLog().warn((CharSequence)("Can't find any node matching the xpath [" + transformation.getXpath() + "]"));
        }
    }

    private void unpackTransformedXARs() throws MojoExecutionException {
        for (Transformation transformation : this.transformations) {
            Set artifacts = this.project.getArtifacts();
            if (artifacts == null) continue;
            for (Artifact artifact : artifacts) {
                String id;
                if (artifact.isOptional() || !"xar".equals(artifact.getType()) || !(id = String.format("%s:%s", artifact.getGroupId(), artifact.getArtifactId())).equals(transformation.getArtifact())) continue;
                this.unpackXARToOutputDirectory(artifact, new String[]{transformation.getFile()}, new String[0]);
            }
        }
    }

    private void unpackDependentXARs() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                if (artifact.isOptional() || !"xar".equals(artifact.getType())) continue;
                this.unpackXARToOutputDirectory(artifact, this.getIncludes(), this.getExcludes());
            }
        }
    }

    private void generatePackageXml(File packageFile, Collection<ArchiveEntry> files) throws Exception {
        this.getLog().info((CharSequence)String.format("Generating package.xml descriptor at [%s]", packageFile.getPath()));
        OutputFormat outputFormat = new OutputFormat("", true);
        outputFormat.setEncoding(this.encoding);
        FileOutputStream out = new FileOutputStream(packageFile);
        XMLWriter writer = new XMLWriter((OutputStream)out, outputFormat);
        writer.write(this.toXML(files));
        writer.close();
        ((OutputStream)out).close();
    }

    private Document toXML(Collection<ArchiveEntry> files) throws Exception {
        DOMDocument doc = new DOMDocument();
        DOMElement packageElement = new DOMElement("package");
        doc.setRootElement((Element)packageElement);
        DOMElement infoElement = new DOMElement("infos");
        packageElement.add((Element)infoElement);
        this.addInfoElements((Element)infoElement);
        DOMElement filesElement = new DOMElement("files");
        packageElement.add((Element)filesElement);
        this.addFileElements(files, (Element)filesElement);
        return doc;
    }

    private void addInfoElements(Element infoElement) {
        DOMElement el = new DOMElement("name");
        el.addText(this.project.getName());
        infoElement.add((Element)el);
        el = new DOMElement("description");
        String description = this.project.getDescription();
        if (description == null) {
            el.addText("");
        } else {
            el.addText(description);
        }
        infoElement.add((Element)el);
        el = new DOMElement("licence");
        el.addText("");
        infoElement.add((Element)el);
        el = new DOMElement("author");
        el.addText("XWiki.Admin");
        infoElement.add((Element)el);
        el = new DOMElement("extensionId");
        el.addText(this.project.getGroupId() + ":" + this.project.getArtifactId());
        infoElement.add((Element)el);
        el = new DOMElement("version");
        el.addText(this.project.getVersion());
        infoElement.add((Element)el);
        el = new DOMElement("backupPack");
        el.addText("false");
        infoElement.add((Element)el);
    }

    private void addFileElements(Collection<ArchiveEntry> files, Element filesElement) throws Exception {
        for (ArchiveEntry entry : files) {
            if (entry.getName().indexOf("META-INF") != -1) continue;
            XWikiDocument xdoc = this.getDocFromXML(entry.getFile());
            String reference = xdoc.getReference();
            DOMElement element = new DOMElement("file");
            element.setText(reference);
            element.addAttribute("language", xdoc.getLocale());
            element.addAttribute("defaultAction", "0");
            XAREntry cfgEntry = this.getEntryMap().get(reference);
            if (cfgEntry != null && cfgEntry.getType() != null) {
                element.addAttribute("type", cfgEntry.getType());
            } else if (this.defaultEntryType != null) {
                element.addAttribute("type", this.defaultEntryType);
            }
            filesElement.add((Element)element);
        }
    }

    protected static Map<String, XAREntry> getXarEntriesMapFromXML(File file) throws Exception {
        try (FileInputStream stream = new FileInputStream(file);){
            Map<String, XAREntry> map = XARMojo.getXarEntriesMapFromXML(stream);
            return map;
        }
    }

    public static Map<String, XAREntry> getXarEntriesMapFromXML(InputStream stream) throws Exception {
        SAXReader reader = new SAXReader();
        Document domdoc = reader.read(stream);
        Element filesElement = domdoc.getRootElement().element("files");
        if (filesElement == null) {
            throw new Exception("The supplied document contains no document list ");
        }
        LinkedHashMap<String, XAREntry> result = new LinkedHashMap<String, XAREntry>();
        List elements = filesElement.elements("file");
        for (Object item : elements) {
            if (!(item instanceof Element)) continue;
            Element currentElement = (Element)item;
            XAREntry entry = new XAREntry();
            entry.setDocument(currentElement.getText());
            entry.setType(currentElement.attributeValue("type"));
            result.put(entry.getDocument(), entry);
        }
        return result;
    }

    protected static Collection<String> getDocumentNamesFromXML(File file) throws Exception {
        return XARMojo.getXarEntriesMapFromXML(file).keySet();
    }

    public static Collection<String> getDocumentNamesFromXML(InputStream stream) throws Exception {
        return XARMojo.getXarEntriesMapFromXML(stream).keySet();
    }

    private void addFilesToArchive(ZipArchiver archiver, File sourceDir) throws Exception {
        File generatedPackageFile = new File(sourceDir, "package.xml");
        if (generatedPackageFile.exists()) {
            generatedPackageFile.delete();
        }
        archiver.addDirectory(sourceDir, this.getIncludes(), this.getExcludes());
        this.generatePackageXml(generatedPackageFile, archiver.getFiles().values());
        archiver.addFile(generatedPackageFile, "package.xml");
    }

    private void addFilesToArchive(ZipArchiver archiver, File sourceDir, File packageXml) throws Exception {
        Collection<String> documentNames;
        this.getLog().info((CharSequence)String.format("Using the existing package.xml descriptor at [%s]", packageXml.getPath()));
        try {
            documentNames = XARMojo.getDocumentNamesFromXML(packageXml);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("The existing [%s] is invalid.", "package.xml"));
            throw e;
        }
        LinkedList<File> fileQueue = new LinkedList<File>();
        XARMojo.addContentsToQueue(fileQueue, sourceDir);
        while (!fileQueue.isEmpty() && !documentNames.isEmpty()) {
            File currentFile = (File)fileQueue.poll();
            if (currentFile.isDirectory()) {
                XARMojo.addContentsToQueue(fileQueue, currentFile);
                continue;
            }
            String documentReference = XWikiDocument.getReference(currentFile);
            if (!documentNames.contains(documentReference)) continue;
            String archivedFilePath = currentFile.getAbsolutePath().substring((sourceDir.getAbsolutePath() + File.separator).length());
            archivedFilePath = archivedFilePath.replace(File.separatorChar, '/');
            archiver.addFile(currentFile, archivedFilePath);
            documentNames.remove(documentReference);
        }
        if (!documentNames.isEmpty()) {
            StringBuilder errorMessage = new StringBuilder("The following documents could not be found: ");
            for (String name : documentNames) {
                errorMessage.append(name);
                errorMessage.append(" ");
            }
            throw new Exception(errorMessage.toString());
        }
        archiver.addFile(packageXml, "package.xml");
    }

    private static void addContentsToQueue(Queue<File> fileQueue, File sourceDir) throws MojoExecutionException {
        File[] files = sourceDir.listFiles();
        if (files != null) {
            for (File currentFile : files) {
                fileQueue.add(currentFile);
            }
        } else {
            throw new MojoExecutionException(String.format("Couldn't get list of files in source dir [%s]", sourceDir));
        }
    }
}

