/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xwiki.tool.xar.AbstractVerifyMojo;
import org.xwiki.tool.xar.internal.XWikiDocument;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class VerifyMojo
extends AbstractVerifyMojo {
    private static final String SYNTAX_PLAIN = "plain/1.0";
    @Parameter(property="xar.verify.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="xar.verify.translationVisibility.skip", defaultValue="false")
    private boolean translationVisibilitySkip;
    @Parameter(property="xar.verify.emptyParent.skip", defaultValue="true")
    private boolean emptyParentSkip;
    @Parameter(property="xar.verify.titles")
    private Properties titles;
    private Map<Pattern, Pattern> titlePatterns;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.getProject().getPackaging().equals("xar") && !this.force) {
            this.getLog().info((CharSequence)"Not a XAR module, skipping validity check...");
            return;
        }
        this.getLog().info((CharSequence)"Checking validity of XAR XML files...");
        this.initializePatterns();
        boolean hasErrors = false;
        Collection<File> xmlFiles = this.getXARXMLFiles();
        for (File file : xmlFiles) {
            String parentName = file.getParentFile().getName();
            XWikiDocument xdoc = this.getDocFromXML(file);
            ArrayList<String> errors = new ArrayList<String>();
            if (!xdoc.getEncoding().equals("UTF-8")) {
                errors.add(String.format("Encoding must be [UTF-8] but was [%s]", xdoc.getEncoding()));
            }
            this.verifyAuthor(errors, xdoc.getEffectiveMetadataAuthor(), String.format("Effective author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getEffectiveMetadataAuthor()), true);
            this.verifyAuthor(errors, xdoc.getOriginalMetadataAuthor(), String.format("Original author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getOriginalMetadataAuthor()), false);
            this.verifyAuthor(errors, xdoc.getContentAuthor(), String.format("Content Author must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getContentAuthor()), true);
            this.verifyAuthor(errors, xdoc.getCreator(), String.format("Creator must be [%s] but was [%s]", "xwiki:XWiki.Admin", xdoc.getCreator()), true);
            this.verifyAttachmentAuthors(errors, xdoc.getAttachmentData());
            if (!this.emptyParentSkip && StringUtils.isEmpty((CharSequence)xdoc.getParent()) && !xdoc.getReference().equals("Main.WebHome")) {
                errors.add("Parent must not be empty");
            }
            if (!xdoc.getVersion().equals("1.1")) {
                errors.add(String.format("Version must be [%s] but was [%s]", "1.1", xdoc.getVersion()));
            }
            if (!StringUtils.isEmpty((CharSequence)xdoc.getComment())) {
                errors.add(String.format("Comment must be empty but was [%s]", xdoc.getComment()));
            }
            if (!xdoc.getMinorEdit().equals("false")) {
                errors.add(String.format("Minor edit must always be [false] but was [%s]", xdoc.getMinorEdit()));
            }
            String expectedDefaultLanguage = this.guessDefaultLanguage(file, xmlFiles);
            if (!xdoc.getDefaultLanguage().equals(expectedDefaultLanguage)) {
                errors.add(String.format("Default Language should have been [%s] but was [%s]", expectedDefaultLanguage, xdoc.getDefaultLanguage()));
            }
            if (!(this.isContentPage(file.getPath()) || this.isVisibleTechnicalPage(file.getPath()) || xdoc.isHidden())) {
                errors.add("Technical documents must be hidden");
            }
            if (!this.isTitlesMatching(xdoc.getReference(), xdoc.getTitle())) {
                errors.add(String.format("[%s] ([%s]) page must have a title matching regex [%s]", file.getName(), xdoc.getReference(), this.getTitlePatternRuleforPage(xdoc.getReference())));
            }
            if (xdoc.containsTranslations() && !xdoc.getSyntaxId().equals(SYNTAX_PLAIN)) {
                errors.add(String.format("[%s] ([%s]) page must use a [%s] syntax", file.getName(), xdoc.getReference(), SYNTAX_PLAIN));
            }
            if (!this.translationVisibilitySkip && xdoc.containsTranslations()) {
                for (String visibility : xdoc.getTranslationVisibilities()) {
                    if (!visibility.equals("USER") && !visibility.equals("GLOBAL")) continue;
                    errors.add(String.format("[%s] ([%s]) page contains a translation using a wrong visibility [%s]. Consider using a [WIKI] visibility.", file.getName(), xdoc.getReference(), visibility));
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)xdoc.getLocale()) && xdoc.isAttachmentPresent()) {
                errors.add(String.format("[%s] ([%s]) translated page contains attachment(s)", file.getName(), xdoc.getReference()));
            }
            if (StringUtils.isNotEmpty((CharSequence)xdoc.getLocale()) && xdoc.isObjectPresent()) {
                errors.add(String.format("[%s] ([%s]) translated page contains object(s)", file.getName(), xdoc.getReference()));
            }
            this.verifyAttachmentMimetypes(errors, xdoc.getAttachmentData());
            if (!this.skipDates) {
                this.verifyDateFields(errors, xdoc);
            }
            if (errors.isEmpty()) {
                this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... ok", parentName, file.getName()));
                continue;
            }
            this.getLog().info((CharSequence)String.format("  Verifying [%s/%s]... errors", parentName, file.getName()));
            for (String error : errors) {
                this.getLog().info((CharSequence)String.format("  - %s", error));
            }
            hasErrors = true;
        }
        if (hasErrors) {
            throw new MojoFailureException("There are errors in the XAR XML files!");
        }
        if (this.formatLicense) {
            this.getLog().info((CharSequence)"Checking for missing XAR XML license headers...");
            this.executeLicenseGoal("check");
        }
    }

    @Override
    protected void initializePatterns() {
        super.initializePatterns();
        HashMap<Pattern, Pattern> patterns = new HashMap<Pattern, Pattern>();
        for (String key : this.titles.stringPropertyNames()) {
            patterns.put(Pattern.compile(key), Pattern.compile(this.titles.getProperty(key)));
        }
        this.titlePatterns = patterns;
    }

    private String getTitlePatternRuleforPage(String documentReference) {
        for (Map.Entry<Pattern, Pattern> entry : this.titlePatterns.entrySet()) {
            if (!entry.getKey().matcher(documentReference).matches()) continue;
            return entry.getValue().pattern();
        }
        return null;
    }

    private void verifyDateFields(List<String> errors, XWikiDocument xdoc) {
        if (!this.skipDatesDocumentList.contains(xdoc.getReference())) {
            if (xdoc.isDatePresent()) {
                errors.add("'date' field is present");
            }
            if (xdoc.isContentUpdateDatePresent()) {
                errors.add("'contentUpdateDate' field is present");
            }
            if (xdoc.isCreationDatePresent()) {
                errors.add("'creationDate' field is present");
            }
            if (xdoc.isAttachmentDatePresent()) {
                errors.add("'attachment/date' field is present");
            }
        }
    }

    private void verifyAuthor(List<String> errors, String author, String message, boolean mandatory) {
        if ((author != null || mandatory) && !"xwiki:XWiki.Admin".equals(author)) {
            errors.add(message);
        }
    }

    private void verifyAttachmentAuthors(List<String> errors, List<Map<String, String>> attachmentData) {
        for (Map<String, String> data : attachmentData) {
            String author = data.get("author");
            this.verifyAuthor(errors, author, String.format("Attachment author must be [%s] but was [%s]", "xwiki:XWiki.Admin", author), true);
        }
    }

    private void verifyAttachmentMimetypes(List<String> errors, List<Map<String, String>> attachmentData) {
        for (Map<String, String> data : attachmentData) {
            String mimetype = data.get("mimetype");
            if (mimetype != null) continue;
            errors.add(String.format("Missing mimetype for attachment [%s]", data.get("filename")));
        }
    }

    private boolean isTitlesMatching(String documentReference, String title) {
        for (Map.Entry<Pattern, Pattern> entry : this.titlePatterns.entrySet()) {
            if (!entry.getKey().matcher(documentReference).matches() || entry.getValue().matcher(title).matches()) continue;
            return false;
        }
        return true;
    }
}

