/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar.internal;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XWikiDocument {
    private static final String AUTHOR_TAG = "author";
    private String reference;
    private String locale;
    private String defaultLanguage;
    private String creator;
    private String author;
    private String contentAuthor;
    private List<String> attachmentAuthors;
    private String version;
    private String parent;
    private String comment;
    private String minorEdit;
    private String encoding;
    private boolean isHidden;
    private String title;
    private String syntaxId;
    private boolean containsTranslations;
    private List<String> translationVisibilities = new ArrayList<String>();

    public void fromXML(File file) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.fromXML(reader.read(file));
    }

    public void fromXML(String file) throws DocumentException {
        SAXReader reader = new SAXReader();
        this.fromXML(reader.read((Reader)new StringReader(file)));
    }

    public void fromXML(Document domdoc) throws DocumentException {
        this.encoding = domdoc.getXMLEncoding();
        Element rootElement = domdoc.getRootElement();
        this.reference = rootElement.attributeValue("reference");
        if (this.reference == null) {
            String name = this.readElement(rootElement, "name");
            String space = this.readElement(rootElement, "web");
            if (name == null && space == null) {
                throw new DocumentException(String.format("Content doesn't point to valid wiki page XML", domdoc.getName()));
            }
            this.reference = space == null ? name : this.escapeSpaceOrPageName(space) + '.' + this.escapeSpaceOrPageName(name);
        }
        this.locale = rootElement.attributeValue("locale");
        if (this.locale == null) {
            this.locale = this.readElement(rootElement, "language");
        }
        this.defaultLanguage = this.readElement(rootElement, "defaultLanguage");
        this.creator = this.readElement(rootElement, "creator");
        this.author = this.readElement(rootElement, AUTHOR_TAG);
        this.contentAuthor = this.readElement(rootElement, "contentAuthor");
        this.version = this.readElement(rootElement, "version");
        this.parent = this.readElement(rootElement, "parent");
        this.comment = this.readElement(rootElement, "comment");
        this.minorEdit = this.readElement(rootElement, "minorEdit");
        this.attachmentAuthors = this.readAttachmentAuthors(rootElement);
        this.isHidden = Boolean.parseBoolean(this.readElement(rootElement, "hidden"));
        this.title = this.readElement(rootElement, "title");
        this.syntaxId = this.readElement(rootElement, "syntaxId");
        if (rootElement.selectNodes("//object/className[text() = 'XWiki.TranslationDocumentClass']").size() > 0) {
            this.containsTranslations = true;
            for (Node node : rootElement.selectNodes("//object/className[text() = 'XWiki.TranslationDocumentClass']/../property/scope")) {
                this.translationVisibilities.add(node.getStringValue());
            }
        }
    }

    private String readElement(Element rootElement, String elementName) {
        String result = null;
        Element element = rootElement.element(elementName);
        if (element != null) {
            result = element.getText();
        }
        return result;
    }

    private List<String> readAttachmentAuthors(Element rootElement) {
        ArrayList<String> authors = new ArrayList<String>();
        for (Object attachmentNode : rootElement.elements("attachment")) {
            authors.add(this.readElement((Element)attachmentNode, AUTHOR_TAG));
        }
        return authors;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getContentAuthor() {
        return this.contentAuthor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getParent() {
        return this.parent;
    }

    public String getComment() {
        return this.comment;
    }

    public String getMinorEdit() {
        return this.minorEdit;
    }

    public List<String> getAttachmentAuthors() {
        return this.attachmentAuthors;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean containsTranslations() {
        return this.containsTranslations;
    }

    public List<String> getTranslationVisibilities() {
        return this.translationVisibilities;
    }

    public String getSyntaxId() {
        return this.syntaxId;
    }

    private String escapeSpaceOrPageName(String name) {
        return name != null ? name.replaceAll("[\\\\\\.]", "\\\\$0") : null;
    }

    public static String getReference(File file) {
        XWikiDocument doc;
        try {
            doc = new XWikiDocument();
            doc.fromXML(file);
        }
        catch (Exception e) {
            return null;
        }
        return doc.getReference();
    }
}

