/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.isolation;

import java.net.URLClassLoader;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.xwiki.test.isolation.IsolatedClassPrefix;

public class IsolatedTestRunner
extends BlockJUnit4ClassRunner {
    public IsolatedTestRunner(Class<?> clazz) throws InitializationError {
        super(IsolatedTestRunner.getFromTestClassloader(clazz));
    }

    private static Class<?> getFromTestClassloader(Class<?> clazz) throws InitializationError {
        String name = clazz.getName();
        IsolatedClassPrefix isolatedClassPrefix = clazz.getAnnotation(IsolatedClassPrefix.class);
        if (isolatedClassPrefix == null) {
            throw new InitializationError("To run test with some classes isolated, you need to define the prefix of these classes using annotation @IsolatedClassPrefix (ie: @IsolatedClassPrefix(\"org.xwiki.mymodule\").");
        }
        String[] prefixes = isolatedClassPrefix.value();
        StringBuilder prefixList = null;
        boolean classMatched = false;
        for (String prefix : prefixes) {
            if (name.startsWith(prefix)) {
                classMatched = true;
            }
            if (prefixList == null) {
                prefixList = new StringBuilder(prefix);
                continue;
            }
            prefixList.append(", ").append(prefix);
        }
        if (!classMatched) {
            throw new InitializationError(String.format("To run test with some classes isolated, your test class should be itself isolated, and therefore, should part of the class prefix used for isolation. Your class [%s] does not match any prefixes in [%s]", name, prefixList));
        }
        try {
            IsolatedTestClassLoader reloadRightClassLoader = new IsolatedTestClassLoader(prefixes);
            return Class.forName(name, true, reloadRightClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    private static class IsolatedTestClassLoader
    extends URLClassLoader {
        private final String[] prefixes;

        IsolatedTestClassLoader(String[] prefixes) {
            super(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs());
            this.prefixes = prefixes;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            for (String prefix : this.prefixes) {
                if (!name.startsWith(prefix)) continue;
                return super.findClass(name);
            }
            return super.loadClass(name);
        }
    }
}

