/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class CaptureConsoleRunListener
extends RunListener {
    private static final boolean SKIP = Boolean.parseBoolean(System.getProperty("xwiki.surefire.captureconsole.skip", "false"));
    private PrintStream savedOut;
    private PrintStream savedErr;
    private ByteArrayOutputStream collectingContentStream;
    private boolean isInErrorAlready;

    public void testFailure(Failure failure) throws Exception {
        this.isInErrorAlready = true;
    }

    public void testAssumptionFailure(Failure failure) {
        this.isInErrorAlready = true;
    }

    public void testRunStarted(Description description) throws Exception {
        if (SKIP) {
            return;
        }
        this.savedOut = System.out;
        this.savedErr = System.err;
        this.collectingContentStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedOut)));
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedErr)));
    }

    public void testRunFinished(Result result) throws Exception {
        if (SKIP) {
            return;
        }
        System.setOut(this.savedOut);
        System.setOut(this.savedErr);
        String outputContent = this.collectingContentStream.toString();
        if (!outputContent.isEmpty() && !this.isInErrorAlready) {
            throw new AssertionError((Object)("There should be no content output to the console by the test! Instead we got [" + outputContent + "]"));
        }
    }
}

