/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestExecutionListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestExecutionListener.class);
    private Boolean skip;

    protected abstract String getSkipSystemPropertyKey();

    protected abstract void executionStartedInternal(TestIdentifier var1);

    protected abstract void executionFinishedInternal(TestIdentifier var1, TestExecutionResult var2);

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.shouldSkip()) {
            return;
        }
        this.executionStartedInternal(testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.shouldSkip()) {
            return;
        }
        this.executionFinishedInternal(testIdentifier, testExecutionResult);
    }

    protected String getPropertyValue(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = this.getPropertyValueFromPOM(propertyName);
        }
        return value;
    }

    boolean shouldSkip() {
        if (this.skip == null) {
            String value = this.getPropertyValue(this.getSkipSystemPropertyKey());
            this.skip = Boolean.parseBoolean(value);
        }
        return this.skip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPropertyValueFromPOM(String propertyName) {
        String value = null;
        if (Files.exists(this.getPOMPath(), new LinkOption[0])) {
            try {
                String content = new String(Files.readAllBytes(this.getPOMPath()));
                Pattern regex = Pattern.compile(String.format("<%s>(.*)</%s>", propertyName, propertyName), 32);
                Matcher regexMatcher = regex.matcher(content);
                if (!regexMatcher.find()) return value;
                return regexMatcher.group(1).trim();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading file [%s]", this.getPOMPath()), e);
            }
        }
        LOGGER.warn("No [{}] file in current directory [{}]", (Object)this.getPOMPath(), (Object)Paths.get("", new String[0]).toAbsolutePath());
        return value;
    }

    private Path getPOMPath() {
        return Paths.get("pom.xml", new String[0]);
    }
}

