/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureConsoleTestExecutionListener
implements TestExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureConsoleTestExecutionListener.class);
    private static final String FALSE = "false";
    private static final String CAPTURECONSOLESKIP_PROPERTY = "xwiki.surefire.captureconsole.skip";
    private static final String XMLSKIP_VALUE = String.format("<%s>true</%s>", "xwiki.surefire.captureconsole.skip", "xwiki.surefire.captureconsole.skip");
    private static final boolean SKIP = Boolean.parseBoolean(System.getProperty("xwiki.surefire.captureconsole.skip", "false"));
    private PrintStream savedOut;
    private PrintStream savedErr;
    private ByteArrayOutputStream collectingContentStream;
    private Boolean skip;

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.shouldSkip()) {
            return;
        }
        this.savedOut = System.out;
        this.savedErr = System.err;
        this.collectingContentStream = new ByteArrayOutputStream();
        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedOut)));
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)this.collectingContentStream, (OutputStream)this.savedErr)));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.shouldSkip()) {
            return;
        }
        System.setOut(this.savedOut);
        System.setOut(this.savedErr);
        String outputContent = this.collectingContentStream.toString();
        if (!outputContent.isEmpty() && testExecutionResult.getStatus().equals((Object)TestExecutionResult.Status.SUCCESSFUL)) {
            throw new AssertionError((Object)String.format("There should be no content output to the console by the test! Instead we got [%s]", outputContent));
        }
    }

    private boolean shouldSkip() {
        if (SKIP) {
            return true;
        }
        if (this.skip == null) {
            this.skip = this.pomContains();
        }
        return this.skip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean pomContains() {
        boolean skipCapture = false;
        if (Files.exists(this.getPOMPath(), new LinkOption[0])) {
            try {
                if (!this.pomContains(XMLSKIP_VALUE).isPresent()) return skipCapture;
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading [%s] file", this.getPOMPath()), e);
            }
        }
        LOGGER.warn("No [{}] file in current directory [{}]", (Object)this.getPOMPath(), (Object)Paths.get("", new String[0]).toAbsolutePath());
        return skipCapture;
    }

    private Optional<String> pomContains(String value) throws IOException {
        try (Stream<String> lines = Files.lines(this.getPOMPath());){
            Optional<String> optional = lines.filter(line -> line.contains(value)).findFirst();
            return optional;
        }
    }

    private Path getPOMPath() {
        return Paths.get("pom.xml", new String[0]);
    }
}

