/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.mockito;

import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.ComponentDescriptorFactory;
import org.xwiki.component.annotation.Role;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.mockito.MockitoComponentManager;

public class MockitoComponentMocker<T> {
    private ComponentDescriptorFactory factory = new ComponentDescriptorFactory();
    private ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
    private MockitoComponentManager componentManager;
    private Class<? extends T> componentImplementationClass;
    private Type componentRoleType;
    private String componentRoleHint;
    private List<Class<?>> excludedComponentRoleDependencies = new ArrayList();

    public MockitoComponentMocker(MockitoComponentManager componentManager, Class<? extends T> componentImplementationClass) {
        this(componentManager, componentImplementationClass, (Type)null);
    }

    public MockitoComponentMocker(MockitoComponentManager componentManager, Class<? extends T> componentImplementationClass, Type componentRoleType) {
        this(componentManager, componentImplementationClass, componentRoleType, null);
    }

    public MockitoComponentMocker(MockitoComponentManager componentManager, Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint) {
        this(componentManager, componentImplementationClass, componentRoleType, componentRoleHint, Collections.emptyList());
    }

    public MockitoComponentMocker(MockitoComponentManager componentManager, Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this.componentManager = componentManager;
        this.componentImplementationClass = componentImplementationClass;
        this.componentRoleType = componentRoleType;
        this.componentRoleHint = componentRoleHint;
        this.excludedComponentRoleDependencies.addAll(excludedComponentRoleDependencies);
    }

    public MockitoComponentMocker(MockitoComponentManager componentManager, Class<? extends T> componentImplementationClass, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this(componentManager, componentImplementationClass, null, null, excludedComponentRoleDependencies);
    }

    public RoleHint<T> mockComponent(Object testInstance) throws Exception {
        for (ComponentDescriptor descriptor : this.factory.createComponentDescriptors(this.componentImplementationClass, this.findComponentRoleType(), 0)) {
            if ((this.componentRoleHint == null || !this.componentRoleHint.equals(descriptor.getRoleHint())) && this.componentRoleHint != null) continue;
            this.registerMockDependencies(descriptor);
            this.componentManager.registerComponent(descriptor);
            return new RoleHint(descriptor.getRoleType(), descriptor.getRoleHint());
        }
        return null;
    }

    public List<Class<?>> getExcludedComponentRoleDependencies() {
        return this.excludedComponentRoleDependencies;
    }

    public Class<?> getComponentImplementationClass() {
        return this.componentImplementationClass;
    }

    private Type findComponentRoleType() {
        Type type;
        Set componentRoleTypes = this.loader.findComponentRoleTypes(this.componentImplementationClass);
        if (this.componentRoleType != null) {
            if (!componentRoleTypes.contains(this.componentRoleType)) {
                throw new RuntimeException("Specified Component Role ([" + String.valueOf(this.componentRoleType) + "]) not found in component");
            }
            type = this.componentRoleType;
        } else {
            if (componentRoleTypes.isEmpty()) {
                throw new RuntimeException(String.format("Couldn't find roles for component [%s]", this.componentRoleType));
            }
            if (componentRoleTypes.size() > 1) {
                throw new RuntimeException("Components with several roles must explicitly specify which role to use.");
            }
            type = (Type)componentRoleTypes.iterator().next();
        }
        return type;
    }

    private void registerMockDependencies(ComponentDescriptor<T> descriptor) throws Exception {
        Collection dependencyDescriptors = descriptor.getComponentDependencies();
        for (ComponentDependency dependencyDescriptor : dependencyDescriptors) {
            Class roleTypeClass = ReflectionUtils.getTypeClass((Type)dependencyDescriptor.getRoleType());
            if (this.excludedComponentRoleDependencies.contains(roleTypeClass) || Logger.class == roleTypeClass || roleTypeClass.isAssignableFrom(List.class) || roleTypeClass.isAssignableFrom(Map.class) || ComponentDescriptor.class == roleTypeClass || this.componentManager.hasComponent(dependencyDescriptor.getRoleType(), dependencyDescriptor.getRoleHint())) continue;
            DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
            cd.setRoleType(dependencyDescriptor.getRoleType());
            cd.setRoleHint(dependencyDescriptor.getRoleHint());
            cd.setRoleTypePriority(0);
            Object dependencyMock = Mockito.mock((Class)roleTypeClass, (String)dependencyDescriptor.getName());
            if (javax.inject.Provider.class == roleTypeClass || Provider.class == roleTypeClass) {
                Type providedType = ReflectionUtils.getLastTypeGenericArgument((Type)dependencyDescriptor.getRoleType());
                Class providedClass = ReflectionUtils.getTypeClass((Type)providedType);
                if (this.componentManager.hasComponent(providedType, dependencyDescriptor.getRoleHint()) || providedClass.isAssignableFrom(List.class) || providedClass.isAssignableFrom(Map.class)) continue;
                if (providedClass.getAnnotation(Role.class) != null) {
                    cd.setRoleType(providedType);
                    dependencyMock = Mockito.mock((Class)providedClass, (String)dependencyDescriptor.getName());
                } else if (javax.inject.Provider.class == roleTypeClass) {
                    provider = (javax.inject.Provider)dependencyMock;
                    Mockito.when((Object)provider.get()).thenReturn(Mockito.mock((Class)providedClass, (String)providedType.toString()));
                } else {
                    provider = (Provider)dependencyMock;
                    Mockito.when((Object)provider.get()).thenReturn(Mockito.mock((Class)providedClass, (String)providedType.toString()));
                }
            }
            this.componentManager.registerComponent((ComponentDescriptor)cd, dependencyMock);
        }
    }
}

