/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.test.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Calls methods annotated with this annotation right after configured components are registered by
 * {@link org.xwiki.test.TestComponentManager}.
 *
 * @version $Id: 0f016d43755fd8429f592c5ca74f41ce06e72b65 $
 * @since 5.2M1
 */
@Documented
@Retention(RUNTIME)
@Target({ METHOD })
@Inherited
public @interface AfterComponent
{
    /**
     * @return the test name to which this annotation applies to. When empty it applies to all tests.
     * @since 12.2
     */
    String value() default "";
}
