/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5.mockito;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstances;
import org.mockito.MockitoAnnotations;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.test.junit5.mockito.InjectComponentManager;
import org.xwiki.test.junit5.mockito.InjectMockComponents;
import org.xwiki.test.junit5.mockito.MockComponent;
import org.xwiki.test.mockito.MockitoComponentManager;
import org.xwiki.test.mockito.MockitoComponentMocker;

public class MockitoComponentManagerExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ComponentAnnotationLoader LOADER = new ComponentAnnotationLoader();
    private static final String COMPONENT_MANAGER = "componentManager";
    private static final String MOCKITO_AUTOCLOSEABLE = "mockitoAutoCloseable";

    public void beforeEach(ExtensionContext context) throws Exception {
        Optional testInstances = context.getTestInstances();
        if (testInstances.isPresent()) {
            for (Object testInstance : ((TestInstances)testInstances.get()).getAllInstances()) {
                this.initializeTestInstance(testInstance, context);
            }
        }
    }

    private void initializeTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.removeComponentManager(context);
        MockitoComponentManagerExtension.loadComponentManager(context);
        MockitoComponentManager mcm = new MockitoComponentManager();
        this.saveComponentManager(context, mcm);
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            if (!field.isAnnotationPresent(InjectComponentManager.class)) continue;
            ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), (Object)((Object)mcm));
        }
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            MockComponent mockComponentAnnotation = field.getAnnotation(MockComponent.class);
            if (mockComponentAnnotation == null) continue;
            Named namedAnnotation = field.getAnnotation(Named.class);
            Class<?> classToMock = mockComponentAnnotation.classToMock() != MockComponent.class ? mockComponentAnnotation.classToMock() : null;
            Object mockComponent = namedAnnotation != null ? mcm.registerMockComponent(field.getGenericType(), namedAnnotation.value(), classToMock, true) : mcm.registerMockComponent(field.getGenericType(), null, classToMock, true);
            ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), mockComponent);
        }
        this.initializeMockitoComponentManager(testInstance, mcm, context);
        this.processInjectMockComponents(testInstance, mcm);
        this.processInjectAnnotations(testInstance, mcm);
        this.saveMockitoAutoCloseable(context, MockitoAnnotations.openMocks((Object)testInstance));
    }

    private void processInjectMockComponents(Object testInstance, MockitoComponentManager mcm) throws Exception {
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            InjectMockComponents annotation = field.getAnnotation(InjectMockComponents.class);
            if (annotation == null) continue;
            this.processSingleInjectMockComponents(testInstance, field, annotation, mcm);
        }
    }

    protected void processSingleInjectMockComponents(Object testInstance, Field field, InjectMockComponents annotation, MockitoComponentManager mcm) throws Exception {
        if (field.getType().isInterface()) {
            throw new Exception(String.format("The type of the field [%s] annotated with @%s cannot be an interface.", InjectMockComponents.class.getSimpleName(), field.getName()));
        }
        List descriptors = LOADER.getComponentsDescriptors(field.getType());
        ComponentDescriptor<?> descriptor = this.getDescriptor(annotation.role(), descriptors, field);
        MockitoComponentMocker mocker = new MockitoComponentMocker(mcm, field.getType(), descriptor.getRoleType(), descriptor.getRoleHint());
        mocker.mockComponent(testInstance);
        Object component = mcm.getInstance(descriptor.getRoleType(), descriptor.getRoleHint());
        ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), (Object)component);
    }

    private void processInjectAnnotations(Object testInstance, MockitoComponentManager mcm) throws Exception {
        for (Field field : ReflectionUtils.getAllFields(testInstance.getClass())) {
            Inject injectAnnotation = field.getAnnotation(Inject.class);
            if (injectAnnotation == null) continue;
            Named namedAnnotation = field.getAnnotation(Named.class);
            this.processSingleInjectAnnotations(testInstance, field, namedAnnotation, mcm);
        }
    }

    private void processSingleInjectAnnotations(Object testInstance, Field field, Named namedAnnotation, MockitoComponentManager mcm) throws Exception {
        if (!field.getType().isInterface()) {
            throw new Exception(String.format("The type of the field [%s] annotated with @%s must be an interface.", Inject.class.getSimpleName(), field.getName()));
        }
        Object component = namedAnnotation == null ? mcm.getInstance(field.getGenericType()) : mcm.getInstance(field.getGenericType(), namedAnnotation.value());
        ReflectionUtils.setFieldValue((Object)testInstance, (String)field.getName(), (Object)component);
    }

    protected void initializeMockitoComponentManager(Object testInstance, MockitoComponentManager mcm, ExtensionContext context) throws Exception {
        Optional testMethod = context.getTestMethod();
        if (testMethod.isPresent()) {
            mcm.initializeTest(testInstance, (Method)testMethod.get(), new Object[]{mcm});
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        MockitoComponentManager mcm = MockitoComponentManagerExtension.loadComponentManager(extensionContext);
        if (mcm != null) {
            mcm.dispose();
        }
        this.loadMockitoAutoCloseable(extensionContext).close();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        return ComponentManager.class.isAssignableFrom(parameter.getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return MockitoComponentManagerExtension.loadComponentManager(extensionContext);
    }

    private ComponentDescriptor<?> getDescriptor(Class<?> role, List<ComponentDescriptor<?>> descriptors, Field field) throws Exception {
        if (!this.isRolePresent(role) && !field.isAnnotationPresent(Named.class)) {
            if (descriptors.isEmpty()) {
                throw new Exception(String.format("The component under field [%s] is not implementing any role.", field.getName()));
            }
            if (descriptors.size() > 1) {
                if (this.areRolesIdentical(descriptors)) {
                    return descriptors.get(0);
                }
                throw new Exception(String.format("The component under field [%s] is implementing several roles ([%s]). Please disambiguate by using the \"role\" parameter of the @%s annotation.", field.getName(), StringUtils.join(descriptors, (char)','), InjectMockComponents.class.getSimpleName()));
            }
            return descriptors.get(0);
        }
        for (ComponentDescriptor<?> descriptor : descriptors) {
            if (this.isRolePresent(role)) {
                Class roleClass = ReflectionUtils.getTypeClass((Type)descriptor.getRoleType());
                if (!roleClass.equals(role)) continue;
                return descriptor;
            }
            String roleHint = field.getAnnotation(Named.class).value();
            if (!descriptor.getRoleHint().equals(roleHint)) continue;
            return descriptor;
        }
        throw new Exception(String.format("The role type specified in the @%s annotation for field [%s] isn't implemented by the component.", field.getName(), InjectMockComponents.class.getSimpleName()));
    }

    private boolean areRolesIdentical(List<ComponentDescriptor<?>> descriptors) {
        boolean areSame = true;
        Object type = null;
        for (ComponentDescriptor<?> descriptor : descriptors) {
            if (type != null && !type.equals(descriptor.getRoleType())) {
                areSame = false;
                break;
            }
            if (type != null) continue;
            type = descriptor.getRoleType();
        }
        return areSame;
    }

    private boolean isRolePresent(Class<?> role) {
        return !role.equals(InjectMockComponents.class);
    }

    public static MockitoComponentManager loadComponentManager(ExtensionContext context) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        return (MockitoComponentManager)((Object)store.get((Object)COMPONENT_MANAGER, MockitoComponentManager.class));
    }

    private void removeComponentManager(ExtensionContext context) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        store.remove((Object)COMPONENT_MANAGER);
    }

    private void saveComponentManager(ExtensionContext context, MockitoComponentManager componentManager) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        store.put((Object)COMPONENT_MANAGER, (Object)componentManager);
    }

    private AutoCloseable loadMockitoAutoCloseable(ExtensionContext context) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        return (AutoCloseable)store.get((Object)MOCKITO_AUTOCLOSEABLE, AutoCloseable.class);
    }

    private void saveMockitoAutoCloseable(ExtensionContext context, AutoCloseable mockitoAutoCloseable) {
        ExtensionContext.Store store = MockitoComponentManagerExtension.getStore(context);
        store.put((Object)MOCKITO_AUTOCLOSEABLE, (Object)mockitoAutoCloseable);
    }

    public static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{MockitoComponentManagerExtension.class, context.getRequiredTestMethod()}));
    }
}

