/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.internal.StackingComponentEventManager;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.observation.ObservationManager;
import org.xwiki.test.annotation.AfterComponent;
import org.xwiki.test.annotation.BeforeComponent;
import org.xwiki.test.internal.ComponentRegistrator;

public class TestComponentManager
extends EmbeddableComponentManager {
    protected ComponentRegistrator componentRegistrator = new ComponentRegistrator();

    public MemoryConfigurationSource registerMemoryConfigurationSource() throws Exception {
        return this.componentRegistrator.registerMemoryConfigurationSource((ComponentManager)this);
    }

    public void registerComponent(Type roleType, String roleHint, Object instance) throws Exception {
        this.componentRegistrator.registerComponent(roleType, roleHint, instance, (ComponentManager)this);
    }

    public void registerComponent(Type roleType, Object instance) throws Exception {
        this.componentRegistrator.registerComponent(roleType, instance, (ComponentManager)this);
    }

    public void registerComponent(Class<?> testClass) throws Exception {
        this.componentRegistrator.registerComponent(testClass, (ComponentManager)this);
    }

    public void registerComponentIfDontExist(Class<?> testClass) throws Exception {
        this.componentRegistrator.registerComponent(testClass, (ComponentManager)this);
    }

    public void initializeTest(Object testClassInstance, Method test, Object ... parameterInstances) throws Exception {
        String target;
        Class<?> testClass = testClassInstance.getClass();
        for (Method method : this.getBeforeComponentAnnotatedMethods(testClass)) {
            target = method.getAnnotation(BeforeComponent.class).value();
            this.invokeMethod(test, target, method, testClassInstance, parameterInstances);
        }
        this.componentRegistrator.registerComponents(testClass, (ComponentManager)this);
        for (Method method : this.getAfterComponentAnnotatedMethods(testClass)) {
            target = method.getAnnotation(AfterComponent.class).value();
            this.invokeMethod(test, target, method, testClassInstance, parameterInstances);
        }
    }

    private List<Method> getBeforeComponentAnnotatedMethods(Class<?> testClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : ReflectionUtils.getAllMethods(testClass)) {
            if (!method.isAnnotationPresent(BeforeComponent.class)) continue;
            String target = method.getAnnotation(BeforeComponent.class).value();
            if (StringUtils.isEmpty((CharSequence)target)) {
                methods.addFirst(method);
                continue;
            }
            methods.addLast(method);
        }
        return methods;
    }

    private List<Method> getAfterComponentAnnotatedMethods(Class<?> testClass) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Method method : ReflectionUtils.getAllMethods(testClass)) {
            if (!method.isAnnotationPresent(AfterComponent.class)) continue;
            String target = method.getAnnotation(AfterComponent.class).value();
            if (StringUtils.isEmpty((CharSequence)target)) {
                methods.addFirst(method);
                continue;
            }
            methods.addLast(method);
        }
        return methods;
    }

    private void invokeMethod(Method test, String target, Method declaredMethod, Object testClassInstance, Object ... parameterInstances) throws Exception {
        if (test == null || StringUtils.isEmpty((CharSequence)target) || target.equalsIgnoreCase(test.getName())) {
            this.invokeMethod(declaredMethod, testClassInstance, parameterInstances);
        }
    }

    public void initializeTest(Object testClassInstance, Object ... parameterInstances) throws Exception {
        this.initializeTest(testClassInstance, null, parameterInstances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMethod(Method declaredMethod, Object testClassInstance, Object ... parameterInstances) throws Exception {
        ArrayList<Object> validatedParameterInstances = new ArrayList<Object>();
        boolean isSupported = true;
        for (Parameter parameter : declaredMethod.getParameters()) {
            boolean hasMatchingParameterInstance = false;
            for (Object object : parameterInstances) {
                if (!object.getClass().isAssignableFrom(parameter.getType())) continue;
                hasMatchingParameterInstance = true;
                validatedParameterInstances.add(object);
                break;
            }
            if (hasMatchingParameterInstance) continue;
            isSupported = false;
            break;
        }
        if (isSupported) {
            boolean isAccessible = declaredMethod.isAccessible();
            try {
                declaredMethod.setAccessible(true);
                declaredMethod.invoke(testClassInstance, validatedParameterInstances.toArray());
            }
            finally {
                declaredMethod.setAccessible(isAccessible);
            }
        }
    }

    public void notifyComponentDescriptorEvent() throws ComponentLookupException {
        if (this.hasComponent((Type)((Object)ObservationManager.class))) {
            StackingComponentEventManager eventManager = new StackingComponentEventManager();
            eventManager.setObservationManager((ObservationManager)this.getInstance((Type)((Object)ObservationManager.class)));
            eventManager.shouldStack(false);
            this.setComponentEventManager((ComponentEventManager)eventManager);
        }
    }

    public void shutdownTest() throws Exception {
        this.dispose();
    }
}

