/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.mockito;

import java.lang.reflect.Type;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.test.mockito.MockitoComponentManager;
import org.xwiki.test.mockito.MockitoComponentManagerRule;
import org.xwiki.test.mockito.MockitoComponentMocker;

public class MockitoComponentMockingRule<T>
extends MockitoComponentManagerRule {
    private Logger mockLogger;
    private RoleHint<T> mockedComponentHint;
    private MockitoComponentMocker<T> mocker;

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass) {
        this.mocker = new MockitoComponentMocker<T>(this, componentImplementationClass);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this.mocker = new MockitoComponentMocker<T>((MockitoComponentManager)this, componentImplementationClass, excludedComponentRoleDependencies);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this.mocker = new MockitoComponentMocker<T>(this, componentImplementationClass, componentRoleType, componentRoleHint, excludedComponentRoleDependencies);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, List<? extends Class<?>> excludedComponentRoleDependencies) {
        this(componentImplementationClass, componentRoleType, null, excludedComponentRoleDependencies);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType, String componentRoleHint) {
        this.mocker = new MockitoComponentMocker<T>(this, componentImplementationClass, componentRoleType, componentRoleHint);
    }

    public MockitoComponentMockingRule(Class<? extends T> componentImplementationClass, Type componentRoleType) {
        this(componentImplementationClass, componentRoleType, (String)null);
    }

    @Override
    public Statement apply(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                MockitoComponentMockingRule.this.before(base, method, target);
                try {
                    base.evaluate();
                }
                finally {
                    MockitoComponentMockingRule.this.after(base, method, target);
                }
            }
        };
    }

    @Override
    protected void before(Statement base, FrameworkMethod method, Object target) throws Throwable {
        super.before(base, method, target);
        this.mockedComponentHint = this.mocker.mockComponent(target);
    }

    protected Object createLogger(Class<?> instanceClass) {
        Object logger;
        if (!this.mocker.getExcludedComponentRoleDependencies().contains(Logger.class) && this.mocker.getComponentImplementationClass() == instanceClass) {
            logger = Mockito.mock(Logger.class, (String)instanceClass.getName());
            this.mockLogger = (Logger)logger;
        } else {
            logger = super.createLogger(instanceClass);
        }
        return logger;
    }

    public T getComponentUnderTest() throws ComponentLookupException {
        return (T)this.getInstance(this.mockedComponentHint.getRoleType(), this.mockedComponentHint.getHint());
    }

    public Logger getMockedLogger() {
        return this.mockLogger;
    }
}

