/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.internal.StackingComponentEventManager;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.internal.MemoryConfigurationSource;
import org.xwiki.observation.ObservationManager;
import org.xwiki.test.annotation.AfterComponent;
import org.xwiki.test.annotation.BeforeComponent;
import org.xwiki.test.internal.ComponentRegistrator;

public class TestComponentManager
extends EmbeddableComponentManager {
    protected ComponentRegistrator componentRegistrator = new ComponentRegistrator();

    public MemoryConfigurationSource registerMemoryConfigurationSource() throws Exception {
        return this.componentRegistrator.registerMemoryConfigurationSource((ComponentManager)this);
    }

    public void registerComponent(Type roleType, String roleHint, Object instance) throws Exception {
        this.componentRegistrator.registerComponent(roleType, roleHint, instance, (ComponentManager)this);
    }

    public void registerComponent(Type roleType, Object instance) throws Exception {
        this.componentRegistrator.registerComponent(roleType, instance, (ComponentManager)this);
    }

    public void registerComponent(Class<?> testClass) throws Exception {
        this.componentRegistrator.registerComponent(testClass, (ComponentManager)this);
    }

    public void registerComponentIfDontExist(Class<?> testClass) throws Exception {
        this.componentRegistrator.registerComponent(testClass, (ComponentManager)this);
    }

    public void initializeTest(Object testClassInstance, Object ... parameterInstances) throws Exception {
        Class<?> testClass = testClassInstance.getClass();
        for (Method declaredMethod : testClass.getMethods()) {
            if (!declaredMethod.isAnnotationPresent(BeforeComponent.class)) continue;
            this.invokeMethod(declaredMethod, testClassInstance, parameterInstances);
        }
        this.componentRegistrator.registerComponents(testClass, (ComponentManager)this);
        for (Method declaredMethod : testClass.getMethods()) {
            if (!declaredMethod.isAnnotationPresent(AfterComponent.class)) continue;
            this.invokeMethod(declaredMethod, testClassInstance, parameterInstances);
        }
    }

    private void invokeMethod(Method declaredMethod, Object testClassInstance, Object ... parameterInstances) throws Exception {
        ArrayList<Object> validatedParameterInstances = new ArrayList<Object>();
        boolean isSupported = true;
        for (Parameter parameter : declaredMethod.getParameters()) {
            boolean hasMatchingParameterInstance = false;
            for (Object object : parameterInstances) {
                if (!object.getClass().isAssignableFrom(parameter.getType())) continue;
                hasMatchingParameterInstance = true;
                validatedParameterInstances.add(object);
                break;
            }
            if (hasMatchingParameterInstance) continue;
            isSupported = false;
            break;
        }
        if (isSupported) {
            declaredMethod.invoke(testClassInstance, validatedParameterInstances.toArray());
        }
    }

    public void notifyComponentDescriptorEvent() throws ComponentLookupException {
        if (this.hasComponent((Type)((Object)ObservationManager.class))) {
            StackingComponentEventManager eventManager = new StackingComponentEventManager();
            eventManager.setObservationManager((ObservationManager)this.getInstance((Type)((Object)ObservationManager.class)));
            eventManager.shouldStack(false);
            this.setComponentEventManager((ComponentEventManager)eventManager);
        }
    }

    public void shutdownTest() throws Exception {
        this.dispose();
    }
}

