/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.plugin.resources.remote.ProcessRemoteResourcesMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

@Mojo(name="process", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class XWikiProcessRemoteResourcesMojo
extends ProcessRemoteResourcesMojo {
    @Parameter(defaultValue="NONE")
    protected ProjectData projectsData;
    @Component
    private MavenProject projectThis;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepositoryThis;
    @Component(role=MavenProjectBuilder.class)
    private MavenProjectBuilder mavenProjectBuilderThis;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositoriesThis;

    protected List<MavenProject> getProjects() {
        switch (this.projectsData) {
            case FULL: {
                return super.getProjects();
            }
            case LICENSES: {
                return this.getLicenses();
            }
        }
        return Collections.emptyList();
    }

    private List<MavenProject> getLicenses() {
        Set artifacts = this.projectThis.getArtifacts();
        ArrayList<MavenProject> licenses = new ArrayList<MavenProject>(artifacts.size());
        for (Artifact artifact : artifacts) {
            try {
                this.getLog().debug((CharSequence)String.format("Building project for [%s]", artifact));
                MavenProject dependencyProject = null;
                try {
                    dependencyProject = this.mavenProjectBuilderThis.buildFromRepository(artifact, this.remoteArtifactRepositoriesThis, this.localRepositoryThis);
                }
                catch (InvalidProjectModelException e) {
                    this.getLog().warn((CharSequence)String.format("Invalid project model for artifact [%s:%s:%s]. It will be ignored by the remote resources Mojo.", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
                    continue;
                }
                Model miniModel = new Model();
                MavenProject miniProject = new MavenProject(miniModel);
                miniProject.setArtifact(dependencyProject.getArtifact());
                miniProject.setGroupId(dependencyProject.getGroupId());
                miniProject.setArtifactId(dependencyProject.getArtifactId());
                miniProject.setVersion(dependencyProject.getVersion());
                miniProject.setUrl(dependencyProject.getUrl());
                for (License license : dependencyProject.getLicenses()) {
                    miniProject.addLicense(XWikiProcessRemoteResourcesMojo.cloneLicense(license));
                }
                miniProject.setOrganization(XWikiProcessRemoteResourcesMojo.cloneOrganization(dependencyProject.getOrganization()));
                licenses.add(miniProject);
            }
            catch (ProjectBuildingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return licenses;
    }

    private static License cloneLicense(License src) {
        if (src == null) {
            return null;
        }
        License result = new License();
        result.setComments(src.getComments());
        result.setDistribution(src.getDistribution());
        result.setName(src.getName());
        result.setUrl(src.getUrl());
        return result;
    }

    private static Organization cloneOrganization(Organization src) {
        if (src == null) {
            return null;
        }
        Organization result = new Organization();
        result.setName(src.getName());
        result.setUrl(src.getUrl());
        return result;
    }

    public static enum ProjectData {
        NONE,
        LICENSES,
        FULL;

    }
}

