/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.Extension;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.repository.internal.ExtensionSerializer;
import org.xwiki.extension.repository.internal.local.DefaultLocalExtension;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.properties.converter.Converter;
import org.xwiki.tool.extension.ExtensionOverride;

public abstract class AbstractExtensionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Component
    protected ProjectBuilder projectBuilder;
    @Parameter
    protected List<ExtensionOverride> extensionOverrides;
    protected ExtensionSerializer extensionSerializer;
    protected Converter<Extension> extensionConverter;

    protected void initializeComponents() throws MojoExecutionException {
        EmbeddableComponentManager componentManager = new EmbeddableComponentManager();
        componentManager.initialize(((Object)((Object)this)).getClass().getClassLoader());
        try {
            this.extensionSerializer = (ExtensionSerializer)componentManager.getInstance(ExtensionSerializer.class);
            this.extensionConverter = (Converter)componentManager.getInstance((Type)new DefaultParameterizedType(null, Converter.class, new Type[]{Extension.class}));
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to load components", (Exception)((Object)e));
        }
    }

    protected MavenProject getMavenProject(Artifact artifact) throws MojoExecutionException {
        try {
            ProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest()).setProcessPlugins(false).setValidationLevel(0).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
            ProjectBuildingResult result = this.projectBuilder.build(artifact, request);
            return result.getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException(String.format("Failed to build project for [%s]", artifact), (Exception)((Object)e));
        }
    }

    protected Extension toExtension(Artifact artifact) throws MojoExecutionException {
        MavenProject mavenProject = this.getMavenProject(artifact);
        return this.toExtension(mavenProject.getModel());
    }

    protected Extension toExtension(Model model) {
        return (Extension)this.extensionConverter.convert(Extension.class, (Object)model);
    }

    protected void saveExtension(File path, Artifact artifact) throws MojoExecutionException, IOException, ParserConfigurationException, TransformerException {
        MavenProject mavenProject = this.getMavenProject(artifact);
        this.saveExtension(path, mavenProject.getModel());
    }

    protected void saveExtension(File path, Model model) throws IOException, ParserConfigurationException, TransformerException {
        Extension mavenExtension = (Extension)this.extensionConverter.convert(Extension.class, (Object)model);
        Object mutableExtension = mavenExtension instanceof MutableExtension ? (MutableExtension)mavenExtension : new DefaultLocalExtension(null, mavenExtension);
        if (!path.exists()) {
            this.override((MutableExtension)mutableExtension);
            try (FileOutputStream stream = new FileOutputStream(path);){
                this.extensionSerializer.saveExtensionDescriptor(mavenExtension, (OutputStream)stream);
            }
        }
    }

    protected void override(MutableExtension extension) {
        if (this.extensionOverrides != null) {
            for (ExtensionOverride extensionOverride : this.extensionOverrides) {
                String featuresString;
                String version;
                String id = (String)extensionOverride.get("id");
                if (!extension.getId().getId().equals(id) || (version = (String)extensionOverride.get("version")) != null && !extension.getId().getVersion().equals(new DefaultVersion(id)) || (featuresString = (String)extensionOverride.get("features")) == null) continue;
                List features = ExtensionUtils.importPropertyStringList((String)featuresString, (boolean)true);
                extension.setExtensionFeatures((Collection)ExtensionIdConverter.toExtensionIdList((Collection)features, (Version)extension.getId().getVersion()));
            }
        }
    }

    protected void saveExtension(Artifact artifact, File directory) throws MojoExecutionException {
        File path = new File(directory, artifact.getArtifactId() + '-' + artifact.getBaseVersion() + ".xed");
        try {
            this.saveExtension(path, artifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to write descriptor for artifact [" + artifact + "]", e);
        }
    }

    protected void saveExtensions(Collection<Artifact> artifacts, File directory, String type) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            if (artifact.isOptional() || type != null && !type.equals(artifact.getType())) continue;
            this.saveExtension(artifact, directory);
        }
    }
}

