/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension;

import java.io.File;
import java.nio.file.attribute.FileTime;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.xwiki.tool.extension.util.AbstractExtensionMojo;

@Mojo(name="xip", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true, threadSafe=true)
public class XIPMojo
extends AbstractExtensionMojo {
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;

    @Override
    public void executeInternal() throws MojoExecutionException {
        this.packageExtensions();
    }

    private void packageExtensions() throws MojoExecutionException {
        this.extensionHelper.storeExtensionDependencies(true);
        this.createPackage();
    }

    private void createPackage() throws MojoExecutionException {
        File xipFile = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".xip");
        ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(xipFile);
        archiver.setIncludeEmptyDirs(false);
        archiver.setCompress(true);
        MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).ifPresent(timestamp -> archiver.configureReproducibleBuild(FileTime.from(timestamp)));
        archiver.addFileSet((FileSet)new DefaultFileSet(new File(this.extensionHelper.getPermanentDirectory(), "extension/repository")));
        try {
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create archive", e);
        }
        this.project.getArtifact().setFile(xipFile);
    }
}

