/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.ExtensionPlanTree;
import org.xwiki.tool.extension.util.AbstractExtensionMojo;

@Mojo(name="dependency-tree", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, threadSafe=true)
public class DependencyTreeMojo
extends AbstractExtensionMojo {
    @Parameter(defaultValue="PROJECT", property="entryPoint")
    private EntryPoint entryPoint;

    @Override
    public void executeInternal() throws MojoExecutionException {
        List<ExtensionPlan> plans = this.entryPoint == EntryPoint.PROJECT ? Collections.singletonList(this.extensionHelper.createInstallPlan(this.extensionHelper.toArtifactModel(this.project.getArtifact(), this.project.getModel()))) : this.extensionHelper.resolveDependencies(this.project, this.entryPoint == EntryPoint.DEPENDENCIES_ISOLATED);
        for (ExtensionPlan plan : plans) {
            this.print(plan.getTree());
        }
    }

    private void print(ExtensionPlanTree tree) {
        for (ExtensionPlanNode node : tree) {
            this.print(node, 0);
        }
    }

    private void print(ExtensionPlanNode node, int level) {
        if (node.getAction().getAction() == ExtensionPlanAction.Action.INSTALL) {
            StringBuilder builder = new StringBuilder();
            if (level > 0) {
                builder.append(StringUtils.repeat((String)"|  ", (int)level));
            }
            builder.append("+- ");
            builder.append(node.getAction().getExtension().getId().getId());
            builder.append(" ");
            builder.append(node.getAction().getExtension().getId().getVersion());
            this.getLog().info((CharSequence)builder.toString());
            int childLevel = level + 1;
            for (ExtensionPlanNode child : node.getChildren()) {
                this.print(child, childLevel);
            }
        }
    }

    public static enum EntryPoint {
        PROJECT,
        DEPENDENCIES,
        DEPENDENCIES_ISOLATED;

    }
}

