/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.extension.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.internal.ExtensionFactory;
import org.xwiki.extension.maven.internal.MavenUtils;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.aether.internal.AetherExtensionRepository;
import org.xwiki.extension.repository.aether.internal.XWikiRepositorySystemSession;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;

public class MavenBuildExtensionRepository
extends AetherExtensionRepository {
    private MavenSession mavenSession;

    public MavenBuildExtensionRepository(MavenSession session, ArtifactRepository localRepository, PlexusContainer plexusContainer, ComponentManager componentManager) throws Exception {
        super((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("maven-build", "maven", null), null, null, plexusContainer, componentManager);
        this.mavenSession = session;
    }

    public static ExtensionId createExtensionId(org.apache.maven.artifact.Artifact artifact) {
        return MavenBuildExtensionRepository.createExtensionId(artifact, null);
    }

    public static ExtensionId createExtensionId(org.apache.maven.artifact.Artifact artifact, ExtensionFactory factory) {
        String extensionId = MavenUtils.toExtensionId((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier());
        return new ExtensionId(extensionId, (Version)(factory != null ? factory.getVersion(artifact.getBaseVersion()) : new DefaultVersion(artifact.getBaseVersion())));
    }

    protected XWikiRepositorySystemSession createRepositorySystemSession() {
        XWikiRepositorySystemSession session = new XWikiRepositorySystemSession(this.mavenSession.getRepositorySession());
        return session;
    }

    public InputStream openStream(Artifact artifact) throws IOException {
        ArtifactResult artifactResult;
        XWikiRepositorySystemSession session = this.createRepositorySystemSession();
        List repositories = this.newResolutionRepositories((RepositorySystemSession)session);
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setRepositories(repositories);
        ArtifactType artifactType = (ArtifactType)XWikiRepositorySystemSession.TYPE_MAPPING.get(artifact.getExtension());
        if (artifactType == null) {
            artifactRequest.setArtifact(artifact);
        } else {
            artifactRequest.setArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifactType.getExtension(), artifact.getVersion()));
        }
        try {
            RepositorySystem repositorySystem = this.getRepositorySystem();
            artifactResult = repositorySystem.resolveArtifact((RepositorySystemSession)session, artifactRequest);
        }
        catch (ArtifactResolutionException e) {
            throw new IOException("Failed to resolve artifact", e);
        }
        File aetherFile = artifactResult.getArtifact().getFile();
        return new AetherExtensionRepository.AetherExtensionFileInputStream(aetherFile, false);
    }

    protected List<RemoteRepository> newResolutionRepositories(RepositorySystemSession session, boolean all) {
        return RepositoryUtils.toRepos((List)this.mavenSession.getCurrentProject().getRemoteArtifactRepositories());
    }
}

