/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.xwiki.store.blob.BlobOption;

public final class BlobOptionSupport {
    private static final String MULTIPLE_OPTIONS_ERROR = "Multiple options of type [%s] are not supported.";
    private static final String SEPARATOR = ", ";

    private BlobOptionSupport() {
    }

    public static <T extends BlobOption> T findSingleOption(Class<T> optionType, BlobOption ... options) {
        BlobOption result = null;
        if (options == null) {
            return null;
        }
        for (BlobOption option : options) {
            if (!optionType.isInstance(option)) continue;
            if (result != null) {
                throw new IllegalArgumentException(MULTIPLE_OPTIONS_ERROR.formatted(optionType.getSimpleName()));
            }
            result = (BlobOption)optionType.cast(option);
        }
        return (T)result;
    }

    public static void validateSupportedOptions(Set<Class<? extends BlobOption>> supportedTypes, BlobOption ... options) {
        if (options == null || options.length == 0) {
            return;
        }
        HashSet unsupportedTypes = new HashSet();
        for (BlobOption option : options) {
            if (option == null || !supportedTypes.stream().noneMatch(type -> type.isInstance(option))) continue;
            unsupportedTypes.add(option.getClass());
        }
        if (!unsupportedTypes.isEmpty()) {
            String unsupportedNames = unsupportedTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(SEPARATOR));
            String supportedNames = supportedTypes.stream().map(Class::getSimpleName).collect(Collectors.joining(SEPARATOR));
            throw new IllegalArgumentException("Unsupported option types: [%s]. Supported types are: [%s]".formatted(unsupportedNames, supportedNames));
        }
    }
}

