/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.xwiki.stability.Unstable;

@Unstable
public final class BlobStorePropertiesBuilder {
    private final String name;
    private final String type;
    private final Map<String, Object> options = new HashMap<String, Object>();

    public BlobStorePropertiesBuilder(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Object> get(String propertyId) {
        return Optional.ofNullable(this.options.get(propertyId));
    }

    public BlobStorePropertiesBuilder set(String propertyId, Object value) {
        this.options.put(propertyId, value);
        return this;
    }

    public BlobStorePropertiesBuilder remove(String propertyId) {
        this.options.remove(propertyId);
        return this;
    }

    public Map<String, Object> getAllProperties() {
        return this.options;
    }
}

