/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.blob;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.stability.Unstable;

@Unstable
public final class BlobPath
implements Comparable<BlobPath>,
Iterable<BlobPath> {
    private static final BlobPath ROOT_INSTANCE = new BlobPath(true, List.of());
    private static final BlobPath EMPTY_RELATIVE = new BlobPath(false, List.of());
    private static final String SEPARATOR = "/";
    private static final String OTHER_CANNOT_BE_NULL = "other must not be null";
    private static final String NAMES_CANNOT_BE_NULL = "names must not be null";
    private static final String RELATIVE_UP = "..";
    private static final String SAME_DIRECTORY = ".";
    private final boolean absolute;
    private final List<String> names;
    private final String canonical;

    private BlobPath(boolean absolute, List<String> names) {
        this.absolute = absolute;
        this.names = List.copyOf(names);
        this.canonical = this.buildCanonical();
    }

    private String buildCanonical() {
        if (this.absolute) {
            if (this.names.isEmpty()) {
                return SEPARATOR;
            }
            return SEPARATOR + String.join((CharSequence)SEPARATOR, this.names);
        }
        if (this.names.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)SEPARATOR, this.names);
    }

    public static BlobPath root() {
        return ROOT_INSTANCE;
    }

    private static List<String> normalize(List<String> segments, boolean absolute) {
        ArrayList<String> stack = new ArrayList<String>(segments.size());
        for (String seg : segments) {
            if (RELATIVE_UP.equals(seg)) {
                if (!stack.isEmpty() && !((String)stack.get(stack.size() - 1)).equals(RELATIVE_UP)) {
                    stack.remove(stack.size() - 1);
                    continue;
                }
                if (absolute) {
                    throw new IllegalArgumentException("Cannot resolve path outside the root");
                }
                stack.add(seg);
                continue;
            }
            if (SAME_DIRECTORY.equals(seg)) continue;
            stack.add(seg);
        }
        return stack;
    }

    public static BlobPath absolute(String ... names) {
        List<String> nameList = names == null ? List.of() : Arrays.asList(names);
        BlobPath.validateNames(nameList, false);
        return nameList.isEmpty() ? ROOT_INSTANCE : new BlobPath(true, nameList);
    }

    public static BlobPath absolute(Iterable<String> names) {
        Objects.requireNonNull(names, NAMES_CANNOT_BE_NULL);
        List<String> nameList = BlobPath.buildNames(names);
        BlobPath.validateNames(nameList, false);
        return nameList.isEmpty() ? ROOT_INSTANCE : new BlobPath(true, nameList);
    }

    public static BlobPath relative(String ... names) {
        List<String> nameList = names == null ? List.of() : Arrays.asList(names);
        BlobPath.validateNames(nameList, true);
        List<String> normalized = BlobPath.normalize(nameList, false);
        return normalized.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, normalized);
    }

    public static BlobPath relative(Iterable<String> names) {
        Objects.requireNonNull(names, NAMES_CANNOT_BE_NULL);
        List<String> nameList = BlobPath.buildNames(names);
        BlobPath.validateNames(nameList, true);
        List<String> normalized = BlobPath.normalize(nameList, false);
        return normalized.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, normalized);
    }

    public static BlobPath parse(CharSequence path) {
        Objects.requireNonNull(path, "path must not be null");
        String value = path.toString();
        if (value.isEmpty()) {
            return BlobPath.relative(new String[0]);
        }
        boolean absolute = value.startsWith(SEPARATOR);
        String[] parts = StringUtils.split((String)value, (char)SEPARATOR.charAt(0));
        List<String> names = parts == null ? List.of() : Arrays.asList(parts);
        BlobPath.validateNames(names, !absolute);
        if (absolute) {
            return names.isEmpty() ? ROOT_INSTANCE : new BlobPath(true, names);
        }
        List<String> normalized = BlobPath.normalize(names, false);
        return normalized.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, normalized);
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRoot() {
        return this.absolute && this.names.isEmpty();
    }

    public BlobPath getRoot() {
        return this.absolute ? ROOT_INSTANCE : null;
    }

    public BlobPath getParent() {
        if (this.names.isEmpty()) {
            return null;
        }
        if (this.names.size() == 1) {
            return this.absolute ? ROOT_INSTANCE : null;
        }
        return new BlobPath(this.absolute, this.names.subList(0, this.names.size() - 1));
    }

    public BlobPath getFileName() {
        if (this.names.isEmpty()) {
            return null;
        }
        String name = this.names.get(this.names.size() - 1);
        return name.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, List.of(name));
    }

    public int getNameCount() {
        return this.names.size();
    }

    public BlobPath getName(int index) {
        if (index < 0 || index >= this.names.size()) {
            throw new IllegalArgumentException("Index out of bounds: %d".formatted(index));
        }
        return new BlobPath(false, List.of(this.names.get(index)));
    }

    public List<String> getNames() {
        return this.names;
    }

    public BlobPath resolve(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        if (other.isAbsolute()) {
            return other;
        }
        if (other.names.isEmpty()) {
            return this;
        }
        ArrayList<String> combined = new ArrayList<String>(this.names.size() + other.names.size());
        combined.addAll(this.names);
        combined.addAll(other.names);
        List<String> normalized = BlobPath.normalize(combined, this.absolute);
        if (this.absolute) {
            return normalized.isEmpty() ? ROOT_INSTANCE : new BlobPath(true, normalized);
        }
        return normalized.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, normalized);
    }

    public BlobPath resolve(String other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.resolve(BlobPath.parse(other));
    }

    public BlobPath resolveSibling(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        if (other.isAbsolute()) {
            return other;
        }
        BlobPath parent = this.getParent();
        if (parent == null) {
            return other;
        }
        return parent.resolve(other);
    }

    public BlobPath resolveSibling(String other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.resolveSibling(BlobPath.parse(other));
    }

    public BlobPath relativize(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        if (this.absolute != other.absolute) {
            throw new IllegalArgumentException("Paths must both be absolute or both be relative.");
        }
        if (this.equals(other)) {
            return EMPTY_RELATIVE;
        }
        int commonLength = this.commonPrefixLength(other);
        ArrayList<String> relative = new ArrayList<String>();
        for (int i = commonLength; i < this.names.size(); ++i) {
            relative.add(RELATIVE_UP);
        }
        relative.addAll(other.names.subList(commonLength, other.names.size()));
        return relative.isEmpty() ? EMPTY_RELATIVE : new BlobPath(false, relative);
    }

    public BlobPath relativize(String other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.relativize(BlobPath.parse(other));
    }

    public BlobPath subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.names.size() || beginIndex >= endIndex) {
            throw new IllegalArgumentException("Invalid subpath range [%d, %d) for path of size %d".formatted(beginIndex, endIndex, this.names.size()));
        }
        return new BlobPath(false, this.names.subList(beginIndex, endIndex));
    }

    public boolean startsWith(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        if (other.names.size() > this.names.size()) {
            return false;
        }
        if (other.absolute != this.absolute) {
            return false;
        }
        for (int i = 0; i < other.names.size(); ++i) {
            if (this.names.get(i).equals(other.names.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.startsWith(BlobPath.parse(other));
    }

    public boolean endsWith(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        if (other.names.size() > this.names.size()) {
            return false;
        }
        if (other.absolute) {
            return this.absolute && this.names.equals(other.names);
        }
        int offset = this.names.size() - other.names.size();
        for (int i = 0; i < other.names.size(); ++i) {
            if (this.names.get(offset + i).equals(other.names.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.endsWith(BlobPath.parse(other));
    }

    private static List<String> buildNames(Iterable<String> sources) {
        Objects.requireNonNull(sources, NAMES_CANNOT_BE_NULL);
        ArrayList<String> names = new ArrayList<String>();
        sources.forEach(names::add);
        return names;
    }

    private static void validateNames(List<String> names, boolean allowDotSegments) {
        for (int i = 0; i < names.size(); ++i) {
            BlobPath.validateName(names.get(i), i, allowDotSegments);
        }
    }

    private static void validateName(String name, int index, boolean allowDotSegments) {
        if (name == null) {
            throw new IllegalArgumentException("Name at index %d must not be null".formatted(index));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name at index %d must not be empty".formatted(index));
        }
        if (name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new IllegalArgumentException("Name at index %d contains an illegal separator: %s".formatted(index, name));
        }
        if (!allowDotSegments && (SAME_DIRECTORY.equals(name) || RELATIVE_UP.equals(name))) {
            throw new IllegalArgumentException("Name at index %d must not be '.' or '..' for absolute paths".formatted(index));
        }
    }

    private int commonPrefixLength(BlobPath other) {
        int count = Math.min(this.names.size(), other.names.size());
        for (int i = 0; i < count; ++i) {
            if (this.names.get(i).equals(other.names.get(i))) continue;
            return i;
        }
        return count;
    }

    @Override
    public Iterator<BlobPath> iterator() {
        return new BlobPathIterator();
    }

    @Override
    public int compareTo(BlobPath other) {
        Objects.requireNonNull(other, OTHER_CANNOT_BE_NULL);
        return this.canonical.compareTo(other.canonical);
    }

    public String toString() {
        return this.canonical;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlobPath)) {
            return false;
        }
        BlobPath other = (BlobPath)obj;
        return this.absolute == other.absolute && this.names.equals(other.names);
    }

    public int hashCode() {
        return Objects.hash(this.absolute, this.names);
    }

    private final class BlobPathIterator
    implements Iterator<BlobPath> {
        private int index;

        private BlobPathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BlobPath.this.names.size();
        }

        @Override
        public BlobPath next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements");
            }
            BlobPath name = BlobPath.this.getName(this.index);
            ++this.index;
            return name;
        }
    }
}

