/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.event.filter;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.observation.event.filter.EventFilter;

public class RegexEventFilter
implements EventFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String filter;
    private final Pattern pattern;

    public RegexEventFilter(String filter) {
        this.filter = filter;
        this.pattern = Pattern.compile(filter);
    }

    @Override
    public String getFilter() {
        return this.filter;
    }

    @Override
    public boolean matches(EventFilter eventFilter) {
        Matcher matcher = this.pattern.matcher(eventFilter.getFilter());
        return matcher.matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexEventFilter that = (RegexEventFilter)o;
        return new EqualsBuilder().append((Object)this.filter, (Object)that.filter).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.filter).toHashCode();
    }
}

