/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.internal.tail;

import java.io.BufferedReader;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Inject;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.Logger;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.ListLogTailResult;
import org.xwiki.logging.internal.tail.AbstractLoggerTail;
import org.xwiki.logging.internal.tail.InputStreamDataInput;
import org.xwiki.logging.tail.EmptyLogTailResult;
import org.xwiki.logging.tail.LogTailResult;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public abstract class AbstractFileLoggerTail
extends AbstractLoggerTail
implements Disposable {
    protected static final String FAILED_STORE_LOG = "Failed to store the log";
    protected static final String FILE_EXTENSION = ".log";
    @Inject
    protected org.slf4j.Logger componentLogger;
    protected final List<IndexEntry> index = new CopyOnWriteArrayList<IndexEntry>();
    protected File logFile;
    protected RandomAccessFile logStore;
    protected long logStoreLength = -1L;
    protected File indexFile;
    protected Writer indexStore;

    public static boolean exist(Path path) {
        return AbstractFileLoggerTail.exist(path, FILE_EXTENSION);
    }

    public static boolean exist(Path path, String extension) {
        return AbstractFileLoggerTail.getLogFile(path, extension).exists();
    }

    protected static File getLogFile(Path path, String extension) {
        File logFile = path.toFile();
        if (!logFile.getName().endsWith(extension)) {
            logFile = new File(logFile.getParentFile(), logFile.getName() + extension);
        }
        return logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Path path, boolean readonly) throws IOException {
        AbstractFileLoggerTail abstractFileLoggerTail = this;
        synchronized (abstractFileLoggerTail) {
            this.logFile = path.toFile();
            String extension = this.getFileExtension();
            if (!this.logFile.getName().endsWith(extension)) {
                this.logFile = new File(this.logFile.getParentFile(), this.logFile.getName() + extension);
            }
            this.logFile.getParentFile().mkdirs();
            this.indexFile = new File(this.logFile.getParentFile(), this.logFile.getName().substring(0, this.logFile.getName().length() - extension.length()) + ".index");
            if (!readonly) {
                Files.deleteIfExists(this.logFile.toPath());
                this.logStore = new RandomAccessFile(this.logFile, "rw");
                this.indexStore = new FileWriter(this.indexFile, false);
            } else if (this.indexFile.exists()) {
                this.loadIndex();
            }
            this.logStoreLength = this.logFile.length();
        }
    }

    protected boolean isReadOnly() {
        return this.indexStore == null;
    }

    protected boolean open() throws FileNotFoundException {
        if (this.logStore == null) {
            this.logStore = new RandomAccessFile(this.logFile, "r");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean open) throws IOException {
        if (open) {
            AbstractFileLoggerTail abstractFileLoggerTail = this;
            synchronized (abstractFileLoggerTail) {
                this.flush();
                if (this.indexStore != null) {
                    this.indexStore.close();
                    this.indexStore = null;
                }
                if (this.logStore != null) {
                    this.logStore.close();
                    this.logStore = null;
                }
            }
        }
    }

    protected String getFileExtension() {
        return FILE_EXTENSION;
    }

    private void loadIndex() {
        this.index.clear();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.indexFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(58);
                this.index.add(new IndexEntry(Long.valueOf(line.substring(0, i)), LogLevel.valueOf((String)line.substring(i + 1))));
            }
        }
        catch (Exception e) {
            this.componentLogger.warn("Failed to read log index file [{}]: {}", (Object)this.indexFile, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public void log(LogEvent logEvent) {
        if (this.logStore != null) {
            this.writeLog(logEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(LogEvent logEvent) {
        if (FAILED_STORE_LOG != logEvent.getMessage()) {
            AbstractFileLoggerTail abstractFileLoggerTail = this;
            synchronized (abstractFileLoggerTail) {
                try {
                    IndexEntry indexEntry = new IndexEntry(this.logStore.length(), logEvent.getLevel());
                    this.index.add(indexEntry);
                    this.logStore.seek(indexEntry.position);
                    this.write(logEvent, this.logStore);
                    this.logStore.write(10);
                    this.logStoreLength = this.logFile.length();
                    this.writeIndex(indexEntry.position, logEvent.getLevel());
                }
                catch (Exception e) {
                    this.componentLogger.error(Logger.ROOT_MARKER, FAILED_STORE_LOG, (Throwable)e);
                }
            }
        }
    }

    private void writeIndex(long position, LogLevel level) throws IOException {
        this.indexStore.append(String.valueOf(position));
        this.indexStore.append(':');
        this.indexStore.append(level.toString());
        this.indexStore.append('\n');
    }

    public LogEvent getLogEvent(int index) {
        this.checkChanged();
        IndexEntry indexEntry = this.getIndexEntry(index);
        if (indexEntry == null) {
            return null;
        }
        return this.getLogEvent(index, indexEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEvent getLogEvent(int index, IndexEntry indexEntry) {
        AbstractFileLoggerTail abstractFileLoggerTail = this;
        synchronized (abstractFileLoggerTail) {
            LogEvent logEvent;
            boolean open = this.open();
            try {
                this.logStore.seek(indexEntry.position);
                Long toPosition = this.index.size() > index + 1 ? this.index.get((int)(index + 1)).position.longValue() : this.logStore.length();
                BoundedInputStream stream = new BoundedInputStream((InputStream)new InputStreamDataInput(this.logStore), toPosition - indexEntry.position);
                logEvent = this.read((InputStream)stream);
            }
            catch (Throwable throwable) {
                try {
                    this.close(open);
                    throw throwable;
                }
                catch (Exception e) {
                    this.componentLogger.error("Faile to retrieve log for [{}]", (Object)this.logFile, (Object)e);
                    return null;
                }
            }
            this.close(open);
            return logEvent;
        }
    }

    private void checkChanged() {
        if (!(!this.isReadOnly() || this.index.isEmpty() || this.logFile.exists() && this.logFile.length() == this.logStoreLength)) {
            this.index.clear();
        }
    }

    public LogEvent getFirstLogEvent(LogLevel from) {
        IndexEntry indexEntry;
        this.checkChanged();
        for (int i = 0; i < this.index.size() && (indexEntry = this.getIndexEntry(i)) != null; ++i) {
            if (!this.isLogLevel(indexEntry, from)) continue;
            return this.getLogEvent(i, indexEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry getIndexEntry(int i) {
        if (this.index.size() <= i) {
            return null;
        }
        IndexEntry indexEntry = this.index.get(i);
        if (this.logFile.length() < indexEntry.position) {
            AbstractFileLoggerTail abstractFileLoggerTail = this;
            synchronized (abstractFileLoggerTail) {
                if (this.logFile.length() == 0L) {
                    this.index.clear();
                } else {
                    this.loadIndex();
                }
                indexEntry = i < this.index.size() ? this.index.get(i) : null;
            }
        }
        return indexEntry;
    }

    private boolean isLogLevel(IndexEntry indexEntry, LogLevel from) {
        return from == null || indexEntry.level.compareTo((Enum)from) <= 0;
    }

    public LogEvent getLastLogEvent(LogLevel from) {
        IndexEntry indexEntry;
        this.checkChanged();
        IndexEntry lastIndexEntry = null;
        int lastIndex = -1;
        for (int i = 0; i < this.index.size() && (indexEntry = this.getIndexEntry(i)) != null; ++i) {
            if (!this.isLogLevel(indexEntry, from)) continue;
            lastIndexEntry = indexEntry;
            lastIndex = i;
        }
        return lastIndexEntry != null ? this.getLogEvent(lastIndex, lastIndexEntry) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogTailResult getLogEvents(LogLevel from, int offset, int limit) {
        AbstractFileLoggerTail abstractFileLoggerTail = this;
        synchronized (abstractFileLoggerTail) {
            int toIndex;
            if (this.index.size() <= offset) {
                return EmptyLogTailResult.INSTANCE;
            }
            int fromIndex = offset;
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if ((toIndex = fromIndex + limit) <= fromIndex || toIndex > this.index.size()) {
                toIndex = this.index.size();
            }
            ArrayList<LogEvent> events = new ArrayList<LogEvent>(toIndex - fromIndex);
            try {
                this.getLogEvents(toIndex, fromIndex, from, events);
            }
            catch (Exception e) {
                this.componentLogger.error("Faile to retrieve log for [{}]", (Object)this.logFile, (Object)e);
            }
            return new ListLogTailResult(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLogEvents(int toIndex, int fromIndex, LogLevel from, List<LogEvent> events) throws IOException {
        boolean open = this.open();
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                IndexEntry indexEntry = this.index.get(i);
                if (!this.isLogLevel(indexEntry, from)) continue;
                events.add(this.getLogEvent(i));
            }
        }
        finally {
            this.close(open);
        }
    }

    public boolean hasLogLevel(LogLevel from) {
        for (IndexEntry indexEntry : this.index) {
            if (!this.isLogLevel(indexEntry, from)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.index.size();
    }

    public Iterator<LogEvent> iterator() {
        return new FileLoggerTailIterator();
    }

    public void flush() throws IOException {
        if (this.indexStore != null) {
            this.indexStore.flush();
        }
    }

    public void close() throws IOException {
        this.close(this.logStore != null);
    }

    public void dispose() throws ComponentLifecycleException {
        try {
            this.close();
        }
        catch (Exception e) {
            throw new ComponentLifecycleException("Failed to close the logger", (Throwable)e);
        }
        this.index.clear();
    }

    protected abstract LogEvent read(InputStream var1);

    protected abstract void write(LogEvent var1, DataOutput var2);

    protected class FileLoggerTailIterator
    implements Iterator<LogEvent> {
        private int current;

        protected FileLoggerTailIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < AbstractFileLoggerTail.this.index.size();
        }

        @Override
        public LogEvent next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                return AbstractFileLoggerTail.this.getLogEvent(this.current++);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get log event in [" + AbstractFileLoggerTail.this.logFile + "]", e);
            }
        }
    }

    protected class IndexEntry {
        private final LogLevel level;
        private Long position;

        public IndexEntry(Long position, LogLevel level) {
            this.level = level;
            this.position = position;
        }

        public String toString() {
            return this.position + ":" + this.level;
        }
    }
}

