/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.event;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.Message;
import org.xwiki.observation.event.Event;

public class LogEvent
extends Message
implements Event {
    public static final Marker MARKER_BEGIN = MarkerFactory.getMarker((String)"xwiki.begin");
    public static final Marker MARKER_END = MarkerFactory.getMarker((String)"xwiki.end");
    private LogLevel level;
    private long timeStamp;

    public LogEvent() {
    }

    public LogEvent(LogEvent logEvent) {
        this(logEvent.getMarker(), logEvent.getLevel(), logEvent.getMessage(), logEvent.getArgumentArray(), logEvent.getThrowable(), logEvent.getTimeStamp());
    }

    public LogEvent(LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this(null, level, message, argumentArray, throwable);
    }

    public LogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this(marker, level, message, argumentArray, throwable, System.currentTimeMillis());
    }

    public LogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable, long timeStamp) {
        super(marker, message, argumentArray, throwable);
        this.level = level;
        this.timeStamp = timeStamp;
    }

    public void log(Logger targetLogger) {
        Object[] argumentArray = this.getArgumentArray();
        if (this.getArgumentArray() == null) {
            LogEvent.log(targetLogger, this.getLevel(), this.getMarker(), this.getMessage(), this.getThrowable());
        } else {
            if (this.getThrowable() != null) {
                argumentArray = ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable());
            }
            LogEvent.log(targetLogger, this.getLevel(), this.getMarker(), this.getMessage(), argumentArray);
        }
    }

    private static void log(Logger targetLogger, LogLevel level, Marker marker, String message, Object[] argumentArray) {
        switch (level) {
            case TRACE: {
                targetLogger.trace(marker, message, argumentArray);
                break;
            }
            case DEBUG: {
                targetLogger.debug(marker, message, argumentArray);
                break;
            }
            case INFO: {
                targetLogger.info(marker, message, argumentArray);
                break;
            }
            case WARN: {
                targetLogger.warn(marker, message, argumentArray);
                break;
            }
            case ERROR: {
                targetLogger.error(marker, message, argumentArray);
                break;
            }
        }
    }

    private static void log(Logger targetLogger, LogLevel level, Marker marker, String message, Throwable throwable) {
        switch (level) {
            case TRACE: {
                targetLogger.trace(marker, message, throwable);
                break;
            }
            case DEBUG: {
                targetLogger.debug(marker, message, throwable);
                break;
            }
            case INFO: {
                targetLogger.info(marker, message, throwable);
                break;
            }
            case WARN: {
                targetLogger.warn(marker, message, throwable);
                break;
            }
            case ERROR: {
                targetLogger.error(marker, message, throwable);
                break;
            }
        }
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean matches(Object otherEvent) {
        return true;
    }

    @Override
    public String toString() {
        return this.getLevel().toString() + ':' + super.toString();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getLevel()).appendSuper(super.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        LogEvent rhs = (LogEvent)object;
        return this.getLevel() == rhs.getLevel();
    }
}

