/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.marker;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Marker;
import org.xwiki.logging.marker.ContainerMarker;
import org.xwiki.stability.Unstable;

@Unstable
public abstract class AbstractContainerMarker
implements ContainerMarker {
    private static final long serialVersionUID = 1L;
    private static final String OPEN = "[ ";
    private static final String CLOSE = " ]";
    private static final String SEP = ", ";
    private final String name;
    private Set<Marker> references;

    public AbstractContainerMarker(String name, Marker ... references) {
        if (name == null) {
            throw new IllegalArgumentException("A marker name cannot be null");
        }
        this.name = name;
        for (Marker reference : references) {
            this.add(reference);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public <M extends Marker> M get(String name) {
        if (this.name.equals(name)) {
            return (M)this;
        }
        if (this.references != null) {
            for (Marker marker : this.references) {
                Object targetMarker;
                if (marker.getName().equals(name)) {
                    return (M)marker;
                }
                if (!(marker instanceof ContainerMarker) || (targetMarker = ((ContainerMarker)marker).get(name)) == null) continue;
                return targetMarker;
            }
        }
        return null;
    }

    public synchronized void add(Marker reference) {
        if (reference == null) {
            throw new IllegalArgumentException("A null value cannot be added to a Marker as reference.");
        }
        if (!reference.contains((Marker)this)) {
            if (this.references == null) {
                this.references = new LinkedHashSet<Marker>();
            }
            this.references.add(reference);
        }
    }

    public synchronized boolean hasReferences() {
        return this.references != null && this.references.size() > 0;
    }

    public boolean hasChildren() {
        return this.hasReferences();
    }

    public synchronized Iterator<Marker> iterator() {
        if (this.references != null) {
            return this.references.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public synchronized boolean remove(Marker referenceToRemove) {
        if (this.references == null) {
            return false;
        }
        return this.references.remove(referenceToRemove);
    }

    public boolean contains(Marker other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.references != null) {
            for (Marker marker : this.references) {
                if (!marker.contains(other)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(String name) {
        if (this.name.equals(name)) {
            return true;
        }
        if (this.references != null) {
            for (Marker marker : this.references) {
                if (!marker.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ').append(OPEN);
        Iterator<Marker> it = this.iterator();
        while (it.hasNext()) {
            Marker reference = it.next();
            sb.append(reference.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }
}

