/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.BeginLogEvent;
import org.xwiki.logging.event.EndLogEvent;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.helpers.MessageParser;

public final class LogUtils {
    private LogUtils() {
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        if (marker != null) {
            if (marker.contains(LogEvent.MARKER_BEGIN)) {
                return new BeginLogEvent(marker, level, message, argumentArray, throwable);
            }
            if (marker.contains(LogEvent.MARKER_END)) {
                return new EndLogEvent(marker, level, message, argumentArray, throwable);
            }
        }
        return new LogEvent(marker, level, message, argumentArray, throwable);
    }

    public static LogEvent translate(LogEvent logEvent, String translatedMessage) {
        if (translatedMessage != null) {
            MessageParser parser = new MessageParser(translatedMessage, true);
            Object[] defaultArguments = logEvent.getArgumentArray();
            Object[] arguments = new Object[defaultArguments.length];
            StringBuilder message = new StringBuilder();
            int index = 0;
            MessageParser.MessageElement element = parser.next();
            while (element != null) {
                if (element instanceof MessageParser.MessageIndex) {
                    message.append("{}");
                    arguments[index++] = defaultArguments[((MessageParser.MessageIndex)element).getIndex()];
                } else {
                    message.append(element.getString());
                }
                element = parser.next();
            }
            while (index < arguments.length) {
                arguments[index] = defaultArguments[index];
                ++index;
            }
            return new LogEvent(logEvent.getMarker(), logEvent.getLevel(), message.toString(), arguments, logEvent.getThrowable());
        }
        return logEvent;
    }
}

