/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.event;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.internal.helpers.ExtendedMessageFormatter;
import org.xwiki.logging.marker.ContainerMarker;
import org.xwiki.logging.marker.TranslationMarker;
import org.xwiki.observation.event.Event;

public class LogEvent
implements Event,
Serializable {
    public static final Marker MARKER_BEGIN = MarkerFactory.getMarker((String)"xwiki.begin");
    public static final Marker MARKER_END = MarkerFactory.getMarker((String)"xwiki.end");
    private static final long serialVersionUID = 1L;
    private Marker marker;
    private LogLevel level;
    private String message;
    private Object[] argumentArray;
    private Throwable throwable;
    private transient String formattedMessage;

    public LogEvent() {
    }

    public LogEvent(LogEvent logEvent) {
        this(logEvent.getMarker(), logEvent.getLevel(), logEvent.getMessage(), logEvent.getArgumentArray(), logEvent.getThrowable());
    }

    public LogEvent(LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this(null, level, message, argumentArray, throwable);
    }

    public LogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this.marker = marker;
        this.level = level;
        this.message = message;
        this.argumentArray = argumentArray;
        this.throwable = throwable;
    }

    public void log(Logger targetLogger) {
        switch (this.level) {
            case TRACE: {
                targetLogger.trace(this.getMarker(), this.getMessage(), ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable()));
                break;
            }
            case DEBUG: {
                targetLogger.debug(this.getMarker(), this.getMessage(), ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable()));
                break;
            }
            case INFO: {
                targetLogger.info(this.getMarker(), this.getMessage(), ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable()));
                break;
            }
            case WARN: {
                targetLogger.warn(this.getMarker(), this.getMessage(), ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable()));
                break;
            }
            case ERROR: {
                targetLogger.error(this.getMarker(), this.getMessage(), ArrayUtils.add((Object[])this.getArgumentArray(), (Object)this.getThrowable()));
                break;
            }
        }
    }

    public Marker getMarker() {
        return this.marker;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    public List<String> getMessageElements() {
        return ExtendedMessageFormatter.parseMessage(this.getMessage(), this.getArgumentArray());
    }

    public String getTranslationKey() {
        ContainerMarker containerMarker;
        TranslationMarker translationMarker;
        if (this.getMarker() instanceof ContainerMarker && (translationMarker = (TranslationMarker)(containerMarker = (ContainerMarker)this.getMarker()).get("xwiki.translation")) != null) {
            return ((TranslationMarker)this.getMarker()).getTranslationKey();
        }
        return null;
    }

    public boolean matches(Object otherEvent) {
        return true;
    }

    public String toString() {
        return this.getLevel().toString() + ':' + this.getFormattedMessage();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getMarker()).append((Object)this.getLevel()).append((Object)this.getMessage()).append(this.getArgumentArray()).append((Object)this.getThrowable()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        LogEvent rhs = (LogEvent)object;
        return new EqualsBuilder().append((Object)this.getMarker(), (Object)rhs.getMarker()).append((Object)this.getLevel(), (Object)rhs.getLevel()).append((Object)this.getMessage(), (Object)rhs.getMessage()).append(this.getArgumentArray(), rhs.getArgumentArray()).append((Object)this.getThrowable(), (Object)rhs.getThrowable()).isEquals();
    }
}

