/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging.event;

import java.util.List;
import javax.inject.Singleton;
import org.slf4j.Marker;
import org.slf4j.helpers.MessageFormatter;
import org.xwiki.component.annotation.Component;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.internal.helpers.ExtendedMessageFormatter;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class LogEvent
implements Event {
    private Marker marker;
    private LogLevel level;
    private String message;
    private Object[] argumentArray;
    private Throwable throwable;
    private transient String formattedMessage;

    public LogEvent() {
    }

    public LogEvent(LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this(null, level, message, argumentArray, throwable);
    }

    public LogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        this.marker = marker;
        this.level = level;
        this.message = message;
        this.argumentArray = argumentArray;
        this.throwable = throwable;
    }

    public boolean matches(Object otherEvent) {
        return true;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    public List<String> getMessageElements() {
        return ExtendedMessageFormatter.parseMessage(this.getMessage(), this.getArgumentArray());
    }

    public String toString() {
        return this.getLevel().toString() + ':' + this.getFormattedMessage();
    }
}

