/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.logging.tail;

import java.util.stream.Stream;

import org.xwiki.logging.event.LogEvent;

/**
 * The result of a log search.
 * 
 * @version $Id: 778cd06889934c76f73e0e798f41bfae2e9fab04 $
 * @since 11.9RC1
 */
public interface LogTailResult extends Iterable<LogEvent>
{
    /**
     * @return a sequential {@code Stream} over the elements in this collection
     */
    Stream<LogEvent> stream();
}
