/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.util.Arrays;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.LogTreeNode;
import org.xwiki.logging.LogUtils;
import org.xwiki.logging.Logger;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.EndEvent;

public class LogTree
extends LogTreeNode
implements Logger {
    private static final long serialVersionUID = 1L;
    private Stack<LogTreeNode> currentNode = new Stack();

    public LogTree() {
        this.currentNode.push(this);
    }

    @Override
    public void log(org.slf4j.Logger targetLogger) {
        for (LogEvent logEvent : this) {
            logEvent.log(targetLogger);
        }
    }

    protected LogEvent log(LogLevel level, String format, Object[] arguments) {
        return this.log(null, level, format, arguments);
    }

    protected LogEvent log(Marker marker, LogLevel level, String format, Object[] arguments) {
        Throwable throwable;
        Object[] actualArray;
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            actualArray = Arrays.copyOf(arguments, arguments.length - 1);
            throwable = (Throwable)arguments[arguments.length - 1];
        } else {
            actualArray = arguments;
            throwable = null;
        }
        return this.log(marker, level, format, actualArray, throwable);
    }

    protected LogEvent log(LogLevel level, String format, Object[] arguments, Throwable throwable) {
        return this.log(null, level, format, arguments, throwable);
    }

    protected LogEvent log(Marker marker, LogLevel level, String format, Object[] arguments, Throwable throwable) {
        LogEvent logEvent = LogUtils.newLogEvent(marker, level, format, arguments, throwable);
        this.log(logEvent);
        return logEvent;
    }

    @Override
    public void log(LogEvent logEvent) {
        if (logEvent instanceof BeginEvent) {
            LogTreeNode node = new LogTreeNode(logEvent);
            this.currentNode.peek().add(node);
            this.currentNode.push(node);
        } else if (logEvent instanceof EndEvent) {
            this.currentNode.peek().add(logEvent);
            this.pop();
        } else {
            this.currentNode.peek().add(logEvent);
        }
    }

    public void pop() {
        if (this.currentNode.peek() != this) {
            this.currentNode.pop();
        }
    }

    public String getName() {
        return null;
    }

    public boolean isTraceEnabled() {
        return true;
    }

    public void trace(String msg) {
        this.trace(msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void trace(String format, Object arg) {
        this.trace((Marker)null, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace((Marker)null, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.trace((Marker)null, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.trace((Marker)null, msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return true;
    }

    public void trace(Marker marker, String msg) {
        this.trace(marker, msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(marker, format, new Object[]{arg});
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(marker, format, new Object[]{arg1, arg2});
    }

    public void trace(Marker marker, String format, Object ... arguments) {
        this.log(marker, LogLevel.TRACE, format, arguments);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.log(marker, LogLevel.TRACE, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public void debug(String msg) {
        this.debug((Marker)null, msg);
    }

    public void debug(String format, Object arg) {
        this.debug((Marker)null, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug((Marker)null, format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.debug((Marker)null, format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.debug((Marker)null, msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return true;
    }

    public void debug(Marker marker, String msg) {
        this.debug(marker, msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(marker, format, new Object[]{arg});
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(marker, format, new Object[]{arg1, arg2});
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.log(marker, LogLevel.DEBUG, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.log(marker, LogLevel.DEBUG, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(String msg) {
        this.info((Marker)null, msg);
    }

    public void info(String format, Object arg) {
        this.info((Marker)null, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info((Marker)null, format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.info((Marker)null, format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.info((Marker)null, msg, t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return true;
    }

    public void info(Marker marker, String msg) {
        this.info(marker, msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(marker, format, new Object[]{arg});
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(marker, format, new Object[]{arg1, arg2});
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.log(marker, LogLevel.INFO, format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.log(marker, LogLevel.INFO, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(String msg) {
        this.warn((Marker)null, msg);
    }

    public void warn(String format, Object arg) {
        this.warn((Marker)null, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn((Marker)null, format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.warn((Marker)null, format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.warn((Marker)null, msg, t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return true;
    }

    public void warn(Marker marker, String msg) {
        this.warn(marker, msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(marker, format, new Object[]{arg});
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(marker, format, new Object[]{arg1, arg2});
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.log(marker, LogLevel.WARN, format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.log(marker, LogLevel.WARN, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(String msg) {
        this.error((Marker)null, msg);
    }

    public void error(String format, Object arg) {
        this.error((Marker)null, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error((Marker)null, format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.error((Marker)null, format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.error((Marker)null, msg, t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return true;
    }

    public void error(Marker marker, String msg) {
        this.error(marker, msg, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(marker, format, new Object[]{arg});
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(marker, format, new Object[]{arg1, arg2});
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.log(marker, LogLevel.ERROR, format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.log(marker, LogLevel.ERROR, msg, ArrayUtils.EMPTY_OBJECT_ARRAY, t);
    }
}

