/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.logging;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.Strings;
import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.Message;
import org.xwiki.logging.event.BeginLogEvent;
import org.xwiki.logging.event.EndLogEvent;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.logging.internal.helpers.AbstractMessageParser;
import org.xwiki.logging.internal.helpers.MessageFormatMessageParser;
import org.xwiki.logging.internal.helpers.SLF4JMessageParser;
import org.xwiki.stability.Unstable;

public final class LogUtils {
    public static final String MESSAGE_FORMAT_SYNTAX = "messagetool/1.0";

    private LogUtils() {
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable) {
        return LogUtils.newLogEvent(marker, level, message, argumentArray, throwable, System.currentTimeMillis());
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] argumentArray, Throwable throwable, long timeStamp) {
        if (marker != null) {
            if (marker.contains(LogEvent.MARKER_BEGIN)) {
                return new BeginLogEvent(marker, level, message, argumentArray, throwable, timeStamp);
            }
            if (marker.contains(LogEvent.MARKER_END)) {
                return new EndLogEvent(marker, level, message, argumentArray, throwable, timeStamp);
            }
        }
        return new LogEvent(marker, level, message, argumentArray, throwable, timeStamp);
    }

    public static LogEvent newLogEvent(Marker marker, LogLevel level, String message, Object[] arguments) {
        Throwable throwable;
        Object[] actualArray;
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            actualArray = Arrays.copyOf(arguments, arguments.length - 1);
            throwable = (Throwable)arguments[arguments.length - 1];
        } else {
            actualArray = arguments;
            throwable = null;
        }
        return LogUtils.newLogEvent(marker, level, message, actualArray, throwable);
    }

    public static LogEvent translate(LogEvent logEvent, String translatedMessage) {
        return (LogEvent)LogUtils.translate((Message)logEvent, translatedMessage);
    }

    @Unstable
    public static Message translate(Message message, String translatedPattern) {
        return LogUtils.translate(message, translatedPattern, null);
    }

    public static <M extends Message> M translate(M message, String translationPattern, String translatedPatternSyntax) {
        if (translationPattern != null) {
            AbstractMessageParser parser = Strings.CS.equals(translatedPatternSyntax, MESSAGE_FORMAT_SYNTAX) ? new MessageFormatMessageParser(translationPattern) : new SLF4JMessageParser(translationPattern);
            Object[] defaultArguments = message.getArgumentArray();
            ArrayList<Object> arguments = new ArrayList<Object>(defaultArguments.length);
            StringBuilder translatedMessage = new StringBuilder();
            AbstractMessageParser.MessageElement element = parser.next();
            while (element != null) {
                if (element instanceof AbstractMessageParser.MessageIndex) {
                    AbstractMessageParser.MessageIndex messageIndex = (AbstractMessageParser.MessageIndex)element;
                    translatedMessage.append("{}");
                    arguments.add(defaultArguments[messageIndex.getIndex()]);
                } else {
                    translatedMessage.append(element.getString());
                }
                element = parser.next();
            }
            for (int index = arguments.size(); index < defaultArguments.length; ++index) {
                arguments.add(defaultArguments[index]);
            }
            if (message instanceof LogEvent) {
                LogEvent logEvent = (LogEvent)message;
                return (M)new LogEvent(logEvent.getMarker(), logEvent.getLevel(), translatedMessage.toString(), arguments.toArray(), logEvent.getThrowable(), logEvent.getTimeStamp());
            }
            return (M)new Message(message.getMarker(), translatedMessage.toString(), arguments.toArray(), message.getThrowable());
        }
        return message;
    }

    @Unstable
    public static Object[] getArgumentArray(Object ... arguments) {
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return Arrays.copyOf(arguments, arguments.length - 1);
        }
        return arguments;
    }

    @Unstable
    public static Throwable getThrowable(Object ... arguments) {
        if (arguments.length > 0 && arguments[arguments.length - 1] instanceof Throwable) {
            return (Throwable)arguments[arguments.length - 1];
        }
        return null;
    }
}

