/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.ComponentDependencyFactory;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.stability.Unstable;

public class ComponentDescriptorFactory {
    private ServiceLoader<ComponentDependencyFactory> componentDependencyFactories = ServiceLoader.load(ComponentDependencyFactory.class);

    @Deprecated
    public <T> List<ComponentDescriptor<T>> createComponentDescriptors(Class<? extends T> componentClass, Class<?> componentRoleClass) {
        return this.createComponentDescriptors(componentClass, (Type)componentRoleClass);
    }

    public <T> List<ComponentDescriptor<T>> createComponentDescriptors(Class<? extends T> componentClass, Type componentRoleType) {
        return this.createComponentDescriptors(componentClass, componentRoleType, 1000);
    }

    @Unstable
    public <T> List<ComponentDescriptor<T>> createComponentDescriptors(Class<? extends T> componentClass, Type componentRoleType, int roleHintPriority) {
        ArrayList<ComponentDescriptor<T>> descriptors = new ArrayList<ComponentDescriptor<T>>();
        Named named = componentClass.getAnnotation(Named.class);
        Component component = componentClass.getAnnotation(Component.class);
        String[] hints = named != null ? new String[]{named.value()} : (component != null && component.hints().length > 0 ? component.hints() : (component != null && component.value().trim().length() > 0 ? new String[]{component.value().trim()} : new String[]{"default"}));
        Priority roleTypePriorityAnnotation = componentClass.getAnnotation(Priority.class);
        int roleTypePriority = roleTypePriorityAnnotation != null ? roleTypePriorityAnnotation.value() : 1000;
        for (String hint : hints) {
            descriptors.add(this.createComponentDescriptor(componentClass, hint, componentRoleType, roleTypePriority, roleHintPriority));
        }
        return descriptors;
    }

    private <T> ComponentDescriptor<T> createComponentDescriptor(Class<? extends T> componentClass, String hint, Type componentRoleType, int roleTypePriority, int roleHintPriority) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setRoleType(componentRoleType);
        descriptor.setImplementation(componentClass);
        descriptor.setRoleHint(hint);
        descriptor.setInstantiationStrategy(this.createComponentInstantiationStrategy(componentClass));
        descriptor.setRoleTypePriority(roleTypePriority);
        descriptor.setRoleHintPriority(roleHintPriority);
        for (Field field : ReflectionUtils.getAllFields(componentClass)) {
            ComponentDependency<?> dependency = this.createComponentDependency(field);
            if (dependency == null) continue;
            descriptor.addComponentDependency(dependency);
        }
        return descriptor;
    }

    private ComponentInstantiationStrategy createComponentInstantiationStrategy(Class<?> componentClass) {
        InstantiationStrategy instantiationStrategy;
        Singleton singleton = componentClass.getAnnotation(Singleton.class);
        ComponentInstantiationStrategy strategy = singleton != null ? ComponentInstantiationStrategy.SINGLETON : ((instantiationStrategy = componentClass.getAnnotation(InstantiationStrategy.class)) != null ? instantiationStrategy.value() : ComponentInstantiationStrategy.SINGLETON);
        return strategy;
    }

    private ComponentDependency<?> createComponentDependency(Field field) {
        ComponentDependencyFactory factory;
        ComponentDependency dependency = null;
        Iterator<ComponentDependencyFactory> iterator = this.componentDependencyFactories.iterator();
        while (iterator.hasNext() && (dependency = (factory = iterator.next()).createComponentDependency(field)) == null) {
        }
        return dependency;
    }
}

