/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDependency;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.text.XWikiToStringBuilder;

public class DefaultComponentDescriptor<T>
extends DefaultComponentRole<T>
implements ComponentDescriptor<T> {
    private Class<? extends T> implementation;
    private ComponentInstantiationStrategy instantiationStrategy = ComponentInstantiationStrategy.SINGLETON;
    private List<ComponentDependency<?>> componentDependencies = new ArrayList();

    public DefaultComponentDescriptor() {
    }

    public DefaultComponentDescriptor(ComponentDescriptor<T> descriptor) {
        super(descriptor);
        this.setImplementation(descriptor.getImplementation());
        this.setInstantiationStrategy(descriptor.getInstantiationStrategy());
        for (ComponentDependency<?> dependency : descriptor.getComponentDependencies()) {
            this.addComponentDependency(new DefaultComponentDependency(dependency));
        }
    }

    public void setImplementation(Class<? extends T> implementation) {
        this.implementation = implementation;
    }

    @Override
    public Class<? extends T> getImplementation() {
        return this.implementation;
    }

    public void setInstantiationStrategy(ComponentInstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    @Override
    public ComponentInstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    @Override
    public Collection<ComponentDependency<?>> getComponentDependencies() {
        return this.componentDependencies;
    }

    public void addComponentDependency(ComponentDependency<?> componentDependency) {
        this.componentDependencies.add(componentDependency);
    }

    public <D> void addComponentDependency(Class<D> role, String roleHint) {
        DefaultComponentDependency<D> componentDependency = new DefaultComponentDependency<D>();
        componentDependency.setRole(role);
        componentDependency.setRoleHint(roleHint);
        this.componentDependencies.add(componentDependency);
    }

    @Override
    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("implementation", this.getImplementation() == null ? null : this.getImplementation().getName());
        builder.append("instantiation", (Object)this.getInstantiationStrategy());
        return builder.toString();
    }

    @Override
    public boolean equals(Object object) {
        ComponentDescriptor cd;
        boolean result = this == object ? true : (object == null || object.getClass() != this.getClass() ? false : super.equals(cd = (ComponentDescriptor)object) && Objects.equals(this.getImplementation(), cd.getImplementation()) && Objects.equals((Object)this.getInstantiationStrategy(), (Object)cd.getInstantiationStrategy()) && Objects.equals(this.getComponentDependencies(), cd.getComponentDependencies()));
        return result;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(super.hashCode());
        builder.append(this.getImplementation());
        builder.append((Object)this.getInstantiationStrategy());
        builder.append(this.getComponentDependencies());
        return builder.toHashCode();
    }
}

