/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.stability.Unstable;

public final class ReflectionUtils {
    private static final String OPEN_GENERIC = "<";
    private static final String CLOSE_GENERIC = ">";

    private ReflectionUtils() {
    }

    public static Collection<Field> getAllFields(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Class<?> targetClass = clazz; targetClass != null; targetClass = targetClass.getSuperclass()) {
            Field[] targetClassFields;
            try {
                targetClassFields = targetClass.getDeclaredFields();
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Failed to get fields for class [" + targetClass.getName() + "] because the class [" + e.getMessage() + "] couldn't be found in the ClassLoader.");
            }
            for (Field field : targetClassFields) {
                if (field.isSynthetic() || fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields.values();
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        Field resultField = null;
        for (Class<?> targetClass = clazz; targetClass != null; targetClass = targetClass.getSuperclass()) {
            try {
                resultField = targetClass.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (resultField == null) {
            throw new NoSuchFieldException("No field named [" + fieldName + "] in class [" + clazz.getName() + "] or superclasses");
        }
        return resultField;
    }

    public static Class getTypeClass(Type type) {
        Class arrrayParameter;
        Class<?> typeClassClass = null;
        if (type instanceof Class) {
            typeClassClass = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            typeClassClass = (Class)((ParameterizedType)type).getRawType();
        } else if (type instanceof GenericArrayType && (arrrayParameter = ReflectionUtils.getTypeClass(((GenericArrayType)type).getGenericComponentType())) != null) {
            typeClassClass = Array.newInstance(arrrayParameter, 0).getClass();
        }
        return typeClassClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object instanceContainingField, String fieldName, Object fieldValue) {
        for (Class<?> targetClass = instanceContainingField.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                try {
                    boolean isAccessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        field.set(instanceContainingField, fieldValue);
                    }
                    finally {
                        field.setAccessible(isAccessible);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set field [" + fieldName + "] in instance of [" + instanceContainingField.getClass().getName() + "]. The Java Security Manager has probably been configured to prevent settting private field values. XWiki requires this ability to work.", e);
                }
                return;
            }
        }
    }

    public static Class<?> getLastGenericFieldType(Field field) {
        return ReflectionUtils.getTypeClass(ReflectionUtils.getLastFieldGenericArgument(field));
    }

    public static Type getLastFieldGenericArgument(Field field) {
        return ReflectionUtils.getLastTypeGenericArgument(field.getGenericType());
    }

    public static Type getLastTypeGenericArgument(Type type) {
        ParameterizedType pType;
        Type[] types;
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            return types[types.length - 1];
        }
        return null;
    }

    public static Class<?> getLastGenericClassType(Class clazz, Class filterClass) {
        Type[] actualTypes;
        ParameterizedType pType;
        Type type = ReflectionUtils.getGenericClassType(clazz, filterClass);
        if (type instanceof ParameterizedType && filterClass.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType()) && (actualTypes = pType.getActualTypeArguments()).length > 0 && actualTypes[actualTypes.length - 1] instanceof Class) {
            return (Class)actualTypes[actualTypes.length - 1];
        }
        return null;
    }

    public static Type getGenericClassType(Class clazz, Class filterClass) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pType;
            if (type == filterClass) {
                return type;
            }
            if (!(type instanceof ParameterizedType) || !filterClass.isAssignableFrom((Class)(pType = (ParameterizedType)type).getRawType())) continue;
            return type;
        }
        return null;
    }

    public static Type[] resolveSuperArguments(Type[] parameters, Type childType) {
        Type[] resolvedPrameters = null;
        if (parameters != null && childType instanceof ParameterizedType) {
            ParameterizedType parameterizedChildType = (ParameterizedType)childType;
            return ReflectionUtils.resolveSuperArguments(parameters, parameterizedChildType.getClass(), parameterizedChildType.getActualTypeArguments());
        }
        return resolvedPrameters;
    }

    public static Type[] resolveSuperArguments(Type[] parameters, Class childClass, Type[] childParameters) {
        Map<TypeVariable, Type> typeMapping;
        if (childParameters != null) {
            TypeVariable<Class<T>>[] declaredChildParameters = childClass.getTypeParameters();
            typeMapping = new HashMap<TypeVariable, Type>();
            for (int i = 0; i < declaredChildParameters.length; ++i) {
                typeMapping.put(declaredChildParameters[i], childParameters[i]);
            }
        } else {
            typeMapping = Collections.emptyMap();
        }
        return ReflectionUtils.resolveTypes(parameters, typeMapping);
    }

    public static Type resolveType(Type type, Map<TypeVariable, Type> typeMapping) {
        Type resolvedType = type;
        if (type instanceof TypeVariable) {
            if (typeMapping == null) {
                return null;
            }
            resolvedType = typeMapping.get(type);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] arguments = parameterizedType.getActualTypeArguments();
            Type[] resolvedArguments = ReflectionUtils.resolveTypes(arguments, typeMapping);
            resolvedType = resolvedArguments != arguments ? new DefaultParameterizedType(parameterizedType.getOwnerType(), (Class)parameterizedType.getRawType(), resolvedArguments) : type;
        }
        return resolvedType;
    }

    private static Type[] resolveTypes(Type[] types, Map<TypeVariable, Type> typeMapping) {
        Type[] resolvedTypes = types;
        for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            Type resovedType = ReflectionUtils.resolveType(type, typeMapping);
            if (resovedType == null) {
                return null;
            }
            if (resovedType != type && resolvedTypes == types) {
                resolvedTypes = new Type[types.length];
                for (int j = 0; j < i; ++j) {
                    resolvedTypes[j] = types[j];
                }
            }
            if (resolvedTypes == types) continue;
            resolvedTypes[i] = resovedType;
        }
        return resolvedTypes;
    }

    public static Type resolveType(Type targetType, Type rootType) {
        Type resolvedType;
        if (targetType instanceof ParameterizedType && rootType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)targetType;
            resolvedType = ReflectionUtils.resolveType((Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments(), ReflectionUtils.getTypeClass(rootType));
        } else {
            resolvedType = ReflectionUtils.resolveType(ReflectionUtils.getTypeClass(rootType), null, ReflectionUtils.getTypeClass(targetType));
        }
        return resolvedType;
    }

    private static Type resolveType(Class<?> rootClass, Type[] parameters, Class<?> targetClass) {
        for (Type interfaceType : rootClass.getGenericInterfaces()) {
            Type type = ReflectionUtils.resolveType(interfaceType, rootClass, parameters, targetClass);
            if (type == null) continue;
            return type;
        }
        Type superType = rootClass.getGenericSuperclass();
        if (superType != null) {
            return ReflectionUtils.resolveType(superType, rootClass, parameters, targetClass);
        }
        return null;
    }

    private static Type resolveType(Type superType, Class<?> rootClass, Type[] parameters, Class<?> targetClass) {
        Type[] interfaceParameters;
        Class interfaceClass;
        Type newType = superType;
        if (newType instanceof ParameterizedType) {
            ParameterizedType interfaceParameterizedType = (ParameterizedType)newType;
            interfaceClass = ReflectionUtils.getTypeClass(newType);
            Type[] variableParameters = interfaceParameterizedType.getActualTypeArguments();
            interfaceParameters = ReflectionUtils.resolveSuperArguments(variableParameters, rootClass, parameters);
            if (interfaceParameters == null) {
                newType = interfaceClass;
            } else if (interfaceParameters != variableParameters) {
                newType = new DefaultParameterizedType(interfaceParameterizedType.getOwnerType(), interfaceClass, interfaceParameters);
            }
        } else if (newType instanceof Class) {
            interfaceClass = (Class)newType;
            interfaceParameters = null;
        } else {
            return null;
        }
        if (interfaceClass == targetClass) {
            return newType;
        }
        return ReflectionUtils.resolveType(interfaceClass, interfaceParameters, targetClass);
    }

    public static Type unserializeType(String serializedType, ClassLoader classLoader) throws ClassNotFoundException {
        String sType = serializedType.replaceAll(" ", "");
        Type type = null;
        if (sType.contains(OPEN_GENERIC)) {
            int firstInferior = sType.indexOf(OPEN_GENERIC);
            int lastSuperior = sType.lastIndexOf(CLOSE_GENERIC);
            String rawType = sType.substring(0, firstInferior);
            String sArguments = sType.substring(firstInferior + 1, lastSuperior);
            ArrayList<Type> argumentTypes = new ArrayList<Type>();
            int nestedArgsDepth = 0;
            int previousSplit = 0;
            for (int i = 0; i < sArguments.length(); ++i) {
                char current = sArguments.charAt(i);
                switch (current) {
                    case '<': {
                        ++nestedArgsDepth;
                        break;
                    }
                    case '>': {
                        --nestedArgsDepth;
                        break;
                    }
                    case ',': {
                        if (nestedArgsDepth != 0) break;
                        argumentTypes.add(ReflectionUtils.unserializeType(sArguments.substring(previousSplit, i), classLoader));
                        previousSplit = i + 1;
                        break;
                    }
                }
                if (i != sArguments.length() - 1) continue;
                argumentTypes.add(ReflectionUtils.unserializeType(sArguments.substring(previousSplit), classLoader));
            }
            type = new DefaultParameterizedType(null, Class.forName(rawType, false, classLoader), argumentTypes.toArray(new Type[1]));
        } else {
            type = Class.forName(sType, false, classLoader);
        }
        return type;
    }

    public static <T extends Annotation> T getDirectAnnotation(Class<T> annotationClass, AnnotatedElement element) {
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }

    public static List<Type> getDirectTypes(Type type) {
        Class clazz = ReflectionUtils.getTypeClass(type);
        if (clazz == null) {
            return Collections.emptyList();
        }
        LinkedList<Type> types = new LinkedList<Type>();
        for (Type interfaceType : clazz.getGenericInterfaces()) {
            types.add(ReflectionUtils.resolveType(interfaceType, type));
        }
        Type superType = clazz.getGenericSuperclass();
        if (superType != null) {
            types.add(ReflectionUtils.resolveType(superType, type));
        }
        return types;
    }

    private static String getTypeName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.getTypeName();
    }

    @Unstable
    public static String serializeType(Type type) {
        if (type == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            String rawTypeName = ReflectionUtils.getTypeName(parameterizedType.getRawType());
            if (parameterizedType.getOwnerType() != null) {
                if (parameterizedType.getOwnerType() instanceof Class) {
                    sb.append(((Class)parameterizedType.getOwnerType()).getName());
                } else {
                    sb.append(parameterizedType.getOwnerType().toString());
                }
                sb.append('.');
                if (parameterizedType.getOwnerType() instanceof ParameterizedType) {
                    sb.append(rawTypeName.replace(((Class)((ParameterizedType)parameterizedType.getOwnerType()).getRawType()).getName() + '$', ""));
                } else {
                    sb.append(rawTypeName);
                }
            } else {
                sb.append(rawTypeName);
            }
            if (parameterizedType.getActualTypeArguments() != null && parameterizedType.getActualTypeArguments().length > 0) {
                sb.append(OPEN_GENERIC);
                boolean first = true;
                for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(ReflectionUtils.getTypeName(typeArgument));
                    first = false;
                }
                sb.append(CLOSE_GENERIC);
            }
        } else {
            sb.append(ReflectionUtils.getTypeName(type));
        }
        return sb.toString();
    }
}

