/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    private static String resolveResourceName(String prefixPath, String resourcePath) {
        Object fullPath;
        if (StringUtils.isEmpty((CharSequence)prefixPath)) {
            fullPath = resourcePath;
            Path normalizedResource = Paths.get((String)fullPath, new String[0]).normalize();
            if (normalizedResource.startsWith("../")) {
                throw new IllegalArgumentException(String.format("The provided resource name [%s] is trying to navigate out of the mandatory root location", resourcePath));
            }
        } else {
            fullPath = prefixPath + resourcePath;
            Path normalizedResource = Paths.get((String)fullPath, new String[0]).normalize();
            if (!normalizedResource.startsWith(prefixPath)) {
                throw new IllegalArgumentException(String.format("The provided resource name [%s] is trying to navigate out of the mandatory prefix [%s]", resourcePath, prefixPath));
            }
        }
        return fullPath;
    }

    public static InputStream getResourceAsStream(ClassLoader classloader, String prefixPath, String resourcePath) {
        return classloader.getResourceAsStream(ClassLoaderUtils.resolveResourceName(prefixPath, resourcePath));
    }

    public static InputStream getResourceAsStream(ClassLoader classloader, String resourcePath) {
        return ClassLoaderUtils.getResourceAsStream(classloader, null, resourcePath);
    }

    public static URL getResource(ClassLoader classloader, String prefixPath, String resourcePath) {
        return classloader.getResource(ClassLoaderUtils.resolveResourceName(prefixPath, resourcePath));
    }

    public static URL getResource(ClassLoader classloader, String resourcePath) {
        return ClassLoaderUtils.getResource(classloader, null, resourcePath);
    }
}

