/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.NamespaceURLClassLoader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component
@Singleton
public class DefaultClassLoaderManager
implements ClassLoaderManager,
Initializable,
Disposable {
    protected ClassLoader containerClassLoader;
    private volatile NamespaceURLClassLoader rootClassLoader;
    @Inject
    private Logger logger;
    private Map<String, NamespaceURLClassLoader> wikiClassLoaderMap = new ConcurrentHashMap<String, NamespaceURLClassLoader>();

    public void initialize() throws InitializationException {
        this.containerClassLoader = Thread.currentThread().getContextClassLoader();
    }

    protected ClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceURLClassLoader getURLClassLoader(String namespace, boolean create) {
        if (this.rootClassLoader == null) {
            DefaultClassLoaderManager defaultClassLoaderManager = this;
            synchronized (defaultClassLoaderManager) {
                if (this.rootClassLoader == null) {
                    this.rootClassLoader = new NamespaceURLClassLoader(this.getContainerClassLoader(), null);
                }
            }
        }
        NamespaceURLClassLoader wikiClassLoader = this.rootClassLoader;
        if (namespace != null && (wikiClassLoader = this.wikiClassLoaderMap.get(namespace)) == null) {
            if (create) {
                wikiClassLoader = new NamespaceURLClassLoader((ClassLoader)this.rootClassLoader, namespace);
                this.wikiClassLoaderMap.put(namespace, wikiClassLoader);
            } else {
                wikiClassLoader = this.rootClassLoader;
            }
        }
        return wikiClassLoader;
    }

    @Override
    public void dropURLClassLoaders() {
        if (this.rootClassLoader != null) {
            for (String namespace : this.wikiClassLoaderMap.keySet()) {
                this.dropURLClassLoader(namespace);
            }
            NamespaceURLClassLoader classloader = this.rootClassLoader;
            this.rootClassLoader = null;
            try {
                classloader.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close root Classloader", (Throwable)e);
            }
        }
    }

    @Override
    public void dropURLClassLoader(String namespace) {
        if (namespace == null) {
            this.dropURLClassLoaders();
        } else {
            NamespaceURLClassLoader classloader = this.wikiClassLoaderMap.remove(namespace);
            if (classloader != null) {
                try {
                    classloader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Failed to close Classloader", (Throwable)e);
                }
            }
        }
    }

    public void dispose() throws ComponentLifecycleException {
        this.dropURLClassLoaders();
    }
}

