/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.jar.internal.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="JarExtensionJobFinishedListener")
public class JarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionUninstalledEvent(), new JobStartedEvent("uninstall"), new JobFinishedEvent("uninstall"));
    @Inject
    private ClassLoaderManager jarExtensionClassLoader;
    @Inject
    private ExtensionInitializer extensionInitializer;
    @Inject
    private Execution execution;

    public String getName() {
        return "JarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    private void pushUninstallLevel() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack<Object> extensions = (Stack<Object>)context.getProperty("extension.jar.uninstalledExtensions");
            if (extensions == null) {
                extensions = new Stack<Object>();
                context.setProperty("extension.jar.uninstalledExtensions", extensions);
            }
            extensions.push(null);
        }
    }

    private void popUninstallLevel() {
        Stack extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = (Stack)context.getProperty("extension.jar.uninstalledExtensions")) != null) {
            extensions.pop();
        }
    }

    private UninstalledExtensionCollection getCurrentJobUninstalledExtensions(boolean create) {
        Stack extensions;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (extensions = (Stack)context.getProperty("extension.jar.uninstalledExtensions")) != null) {
            UninstalledExtensionCollection collection = (UninstalledExtensionCollection)extensions.peek();
            if (collection == null) {
                collection = new UninstalledExtensionCollection();
                extensions.set(extensions.size() - 1, collection);
            }
            return collection;
        }
        return null;
    }

    private void addUninstalledExtension(ExtensionId id, String namespace) {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(true);
        if (collection != null) {
            collection.add(namespace);
        }
    }

    public void onEvent(Event event, Object o, Object o1) {
        if (event instanceof ExtensionUninstalledEvent) {
            this.onExtensionUninstalledEvent(event);
        } else if (event instanceof JobStartedEvent) {
            this.onJobStartedEvent(event);
        } else {
            this.onJobFinishedEvent(event);
        }
    }

    private void onExtensionUninstalledEvent(Event event) {
        ExtensionUninstalledEvent uninstallEvent = (ExtensionUninstalledEvent)event;
        this.addUninstalledExtension(uninstallEvent.getExtensionId(), uninstallEvent.getNamespace());
    }

    private void onJobStartedEvent(Event event) {
        this.pushUninstallLevel();
    }

    private void onJobFinishedEvent(Event event) {
        UninstalledExtensionCollection collection = this.getCurrentJobUninstalledExtensions(false);
        this.popUninstallLevel();
        if (collection != null) {
            if (collection.rootNamespace) {
                this.jarExtensionClassLoader.dropURLClassLoaders();
                this.extensionInitializer.initialize(null, "jar");
            } else if (collection.namespaces != null) {
                for (String namespace : collection.namespaces) {
                    this.jarExtensionClassLoader.dropURLClassLoader(namespace);
                    this.extensionInitializer.initialize(namespace, "jar");
                }
            }
        }
    }

    private static final class UninstalledExtensionCollection {
        boolean rootNamespace = false;
        public Set<String> namespaces;

        private UninstalledExtensionCollection() {
        }

        public void add(String namespace) {
            if (!this.rootNamespace) {
                if (namespace != null) {
                    if (this.namespaces == null) {
                        this.namespaces = new HashSet<String>();
                    }
                    this.namespaces.add(namespace);
                } else {
                    this.rootNamespace = true;
                }
            }
        }
    }
}

