/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionNotFoundException;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.AbstractAdvancedSearchableExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryException;
import org.xwiki.extension.repository.ExtensionRepositoryFactory;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.ExtensionRepositorySource;
import org.xwiki.extension.repository.internal.RepositoryUtils;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.AdvancedSearchable;
import org.xwiki.extension.repository.search.ExtensionQuery;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.repository.search.Searchable;
import org.xwiki.extension.version.Version;

@Component
@Singleton
public class DefaultExtensionRepositoryManager
extends AbstractAdvancedSearchableExtensionRepository
implements ExtensionRepositoryManager,
Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    private List<ExtensionRepositorySource> repositoriesSources;
    private final Map<String, ExtensionRepositoryEntry> repositoryMap = Collections.synchronizedMap(new LinkedHashMap());
    private List<ExtensionRepository> repositories = Collections.emptyList();
    private LRUMap<ExtensionRepositoryDescriptor, ExtensionRepository> repositoriesCache = new LRUMap(100);

    public void initialize() throws InitializationException {
        this.setDescriptor(new DefaultExtensionRepositoryDescriptor("remote"));
        for (ExtensionRepositorySource repositoriesSource : this.repositoriesSources) {
            for (ExtensionRepositoryDescriptor repositoryDescriptor : repositoriesSource.getExtensionRepositoryDescriptors()) {
                try {
                    this.addRepository(repositoryDescriptor, repositoriesSource.getPriority());
                }
                catch (ExtensionRepositoryException e) {
                    this.logger.error("Failed to add repository [" + repositoryDescriptor + "]", (Throwable)e);
                }
            }
        }
    }

    private void updateRepositories() {
        Stream<ExtensionRepositoryEntry> entryStream = this.repositoryMap.values().stream();
        entryStream = entryStream.sorted();
        this.repositories = entryStream.map(ExtensionRepositoryEntry::getRepository).collect(Collectors.toList());
    }

    @Override
    @Deprecated
    public ExtensionRepository addRepository(ExtensionRepositoryId repositoryId) throws ExtensionRepositoryException {
        return this.addRepository((ExtensionRepositoryDescriptor)repositoryId);
    }

    @Override
    public ExtensionRepository addRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        return this.addRepository(repositoryDescriptor, 500);
    }

    @Override
    public ExtensionRepository addRepository(ExtensionRepositoryDescriptor repositoryDescriptor, int priority) throws ExtensionRepositoryException {
        ExtensionRepository repository;
        try {
            ExtensionRepositoryFactory repositoryFactory = (ExtensionRepositoryFactory)this.componentManager.getInstance(ExtensionRepositoryFactory.class, repositoryDescriptor.getType());
            repository = repositoryFactory.createRepository(repositoryDescriptor);
            this.addRepository(repository, priority);
        }
        catch (ComponentLookupException e) {
            throw new ExtensionRepositoryException("Unsupported repository type [" + repositoryDescriptor.getType() + "]", e);
        }
        return repository;
    }

    @Override
    public void addRepository(ExtensionRepository repository) {
        this.addRepository(repository, 500);
    }

    @Override
    public void addRepository(ExtensionRepository repository, int priority) {
        this.repositoryMap.put(repository.getDescriptor().getId(), new ExtensionRepositoryEntry(repository, priority));
        this.updateRepositories();
    }

    @Override
    public void removeRepository(String repositoryId) {
        this.repositoryMap.remove(repositoryId);
        this.updateRepositories();
    }

    @Override
    public ExtensionRepository getRepository(String repositoryId) {
        ExtensionRepositoryEntry entry = this.repositoryMap.get(repositoryId);
        return entry != null ? entry.getRepository() : null;
    }

    private ExtensionRepository getRepository(ExtensionRepositoryDescriptor repositoryDescriptor) throws ExtensionRepositoryException {
        ExtensionRepository repository = (ExtensionRepository)this.repositoriesCache.get((Object)repositoryDescriptor);
        if (repository == null) {
            if (repositoryDescriptor.getId() != null) {
                repository = this.getRepository(repositoryDescriptor.getId());
            }
            if (repository == null || !repository.getDescriptor().equals(repositoryDescriptor)) {
                ExtensionRepositoryFactory repositoryFactory;
                try {
                    repositoryFactory = (ExtensionRepositoryFactory)this.componentManager.getInstance(ExtensionRepositoryFactory.class, repositoryDescriptor.getType());
                }
                catch (ComponentLookupException e) {
                    throw new ExtensionRepositoryException("Unsupported extension repository type [{" + repositoryDescriptor.getType() + "}]", e);
                }
                repository = repositoryFactory.createRepository(repositoryDescriptor);
            }
            this.repositoriesCache.put((Object)repositoryDescriptor, (Object)repository);
        }
        return repository;
    }

    @Override
    public Collection<ExtensionRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        ResolveException lastException = null;
        for (ExtensionRepository repository : this.repositories) {
            try {
                return repository.resolve(extensionId);
            }
            catch (ExtensionNotFoundException e1) {
                this.logger.debug("Could not find extension [{}] in repository [{}]", new Object[]{extensionId, repository.getDescriptor(), e1});
            }
            catch (ResolveException e2) {
                this.logger.error("Unexpected error when trying to find extension [{}] in repository [{}]", new Object[]{extensionId, repository.getDescriptor(), e2});
                lastException = e2;
            }
        }
        if (lastException != null) {
            throw new ResolveException(MessageFormat.format("Failed to resolve extension [{0}]", extensionId), lastException);
        }
        throw new ExtensionNotFoundException(MessageFormat.format("Could not find extension [{0}]", extensionId));
    }

    @Override
    public Extension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        HashSet<ExtensionRepositoryDescriptor> checkedRepositories = new HashSet<ExtensionRepositoryDescriptor>();
        ResolveException lastException = null;
        for (ExtensionRepositoryDescriptor repositoryDescriptor : extensionDependency.getRepositories()) {
            ExtensionRepository repository;
            if (checkedRepositories.contains(repositoryDescriptor)) continue;
            checkedRepositories.add(repositoryDescriptor);
            try {
                repository = this.getRepository(repositoryDescriptor);
            }
            catch (ExtensionRepositoryException e) {
                this.logger.warn("Invalid repository [{}] in extension dependency", new Object[]{extensionDependency.getRepositories(), extensionDependency, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                continue;
            }
            try {
                return repository.resolve(extensionDependency);
            }
            catch (ExtensionNotFoundException e1) {
                this.logger.debug("Could not find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getDescriptor(), e1});
            }
            catch (ResolveException e2) {
                this.logger.warn("Unexpected error when trying to find extension dependency [{}] in repository [{}]: ", new Object[]{extensionDependency, repository.getDescriptor(), ExceptionUtils.getRootCauseMessage((Throwable)e2)});
                lastException = e2;
            }
        }
        for (ExtensionRepository repository : this.repositories) {
            if (checkedRepositories.contains(repository.getDescriptor())) continue;
            checkedRepositories.add(repository.getDescriptor());
            try {
                return repository.resolve(extensionDependency);
            }
            catch (ExtensionNotFoundException e1) {
                this.logger.debug("Could not find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getDescriptor(), e1});
            }
            catch (ResolveException e2) {
                this.logger.error("Unexpected error when trying to find extension dependency [{}] in repository [{}]", new Object[]{extensionDependency, repository.getDescriptor(), e2});
                lastException = e2;
            }
        }
        if (lastException != null) {
            throw new ResolveException(MessageFormat.format("Failed to resolve extension dependency [{0}]", extensionDependency), lastException);
        }
        throw new ExtensionNotFoundException(MessageFormat.format("Could not find extension dependency [{0}]", extensionDependency));
    }

    @Override
    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        TreeSet<Version> versionSet = new TreeSet<Version>();
        for (ExtensionRepository repository : this.repositories) {
            try {
                IterableResult<Version> versions = repository.resolveVersions(id, 0, -1);
                for (Version version : versions) {
                    versionSet.add(version);
                }
            }
            catch (ExtensionNotFoundException e1) {
                this.logger.debug("Could not find extension with id [{}] in repository [{}]", new Object[]{id, repository.getDescriptor(), e1});
            }
            catch (ResolveException e2) {
                this.logger.error("Unexpected error when trying to find versions for extension with id [{}]", (Object)id, (Object)e2);
            }
        }
        if (versionSet.isEmpty()) {
            throw new ExtensionNotFoundException(MessageFormat.format("Could not find versions for extension with id [{0}]", id));
        }
        return RepositoryUtils.getIterableResult(offset, nb, versionSet);
    }

    @Override
    public boolean exists(ExtensionId extensionId) {
        for (ExtensionRepository repository : this.repositories) {
            if (!repository.exists(extensionId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IterableResult<Extension> search(ExtensionQuery query) throws SearchException {
        IterableResult<Extension> searchResult = null;
        int currentOffset = query.getOffset() > 0 ? query.getOffset() : 0;
        int currentNb = query.getLimit();
        for (ExtensionRepository repository : this.repositories) {
            try {
                ExtensionQuery customQuery = query;
                if (currentOffset != customQuery.getOffset() && currentNb != customQuery.getLimit()) {
                    customQuery = new ExtensionQuery(query);
                    customQuery.setOffset(currentOffset);
                    customQuery.setLimit(currentNb);
                }
                if ((searchResult = this.search(repository, customQuery, searchResult)) == null) continue;
                if (currentOffset > 0 && (currentOffset = query.getOffset() - searchResult.getTotalHits()) < 0) {
                    currentOffset = 0;
                }
                if (currentNb <= 0 || (currentNb = query.getLimit() - searchResult.getSize()) >= 0) continue;
                currentNb = 0;
            }
            catch (SearchException e) {
                this.logger.error("Failed to search on repository [{}] with query [{}]. Ignore and go to next repository.", new Object[]{repository.getDescriptor().toString(), query, e});
            }
        }
        return searchResult != null ? searchResult : new CollectionIterableResult<Extension>(0, query.getOffset(), Collections.emptyList());
    }

    private IterableResult<Extension> search(ExtensionRepository repository, ExtensionQuery query, IterableResult<Extension> previousSearchResult) throws SearchException {
        IterableResult<Extension> result;
        if (repository instanceof Searchable) {
            if (repository instanceof AdvancedSearchable) {
                AdvancedSearchable searchableRepository = (AdvancedSearchable)((Object)repository);
                result = searchableRepository.search(query);
            } else {
                Searchable searchableRepository = (Searchable)((Object)repository);
                result = searchableRepository.search(query.getQuery(), query.getOffset(), query.getLimit());
            }
            if (previousSearchResult != null) {
                result = RepositoryUtils.appendSearchResults(previousSearchResult, result);
            }
        } else {
            result = previousSearchResult;
        }
        return result;
    }

    @Override
    public boolean isFilterable() {
        for (ExtensionRepository repository : this.repositories) {
            if (!(repository instanceof AdvancedSearchable) || !((AdvancedSearchable)((Object)repository)).isFilterable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSortable() {
        for (ExtensionRepository repository : this.repositories) {
            if (!(repository instanceof AdvancedSearchable) || !((AdvancedSearchable)((Object)repository)).isSortable()) continue;
            return true;
        }
        return false;
    }

    private class ExtensionRepositoryEntry
    implements Comparable<ExtensionRepositoryEntry> {
        private ExtensionRepository repository;
        private int priority;

        public ExtensionRepositoryEntry(ExtensionRepository repository, int priority) {
            this.repository = repository;
            this.priority = priority;
        }

        @Override
        public int compareTo(ExtensionRepositoryEntry other) {
            return this.priority - other.priority;
        }

        public ExtensionRepository getRepository() {
            return this.repository;
        }

        public String toString() {
            return this.getRepository().toString();
        }
    }
}

