/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.MutableExtension;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.stability.Unstable;

public abstract class AbstractExtension
implements MutableExtension {
    protected ExtensionId id;
    @Deprecated
    protected Set<String> features;
    protected Map<String, ExtensionId> featuresMap;
    protected String type;
    protected String name;
    protected List<ExtensionLicense> licenses;
    protected String summary;
    protected String description;
    protected List<ExtensionAuthor> authors;
    protected String website;
    protected Set<String> allowedNamespaces;
    protected ExtensionRepository repository;
    protected Map<String, Object> properties;
    protected ReentrantLock propertiesLock = new ReentrantLock();
    protected List<ExtensionDependency> dependencies;
    protected List<ExtensionDependency> managedDependencies;
    protected ExtensionScm scm;
    protected ExtensionIssueManagement issueManagement;
    protected String category;
    protected List<ExtensionRepositoryDescriptor> repositories;
    protected ExtensionFile file;

    public AbstractExtension(ExtensionRepository repository, ExtensionId id, String type) {
        this.repository = repository;
        this.id = id;
        this.type = type;
    }

    public AbstractExtension(ExtensionRepository repository, Extension extension) {
        this(repository, extension.getId(), extension.getType());
        this.set(extension);
    }

    @Override
    public void set(Extension extension) {
        this.setName(extension.getName());
        this.setDescription(extension.getDescription());
        this.setAuthors(extension.getAuthors());
        this.setWebsite(extension.getWebSite());
        this.setLicenses(extension.getLicenses());
        this.setSummary(extension.getSummary());
        this.setIssueManagement(extension.getIssueManagement());
        this.setScm(extension.getScm());
        this.setCategory(extension.getCategory());
        this.setExtensionFeatures(extension.getExtensionFeatures());
        this.setAllowedNamespaces(extension.getAllowedNamespaces());
        this.setDependencies(extension.getDependencies());
        this.setManagedDependencies(extension.getManagedDependencies());
        this.setProperties(extension.getProperties());
    }

    @Override
    public <T> T get(String fieldName) {
        switch (fieldName.toLowerCase()) {
            case "repository": {
                return (T)this.getRepository();
            }
            case "id": {
                return (T)this.getId().getId();
            }
            case "version": {
                return (T)this.getId().getVersion();
            }
            case "feature": 
            case "features": {
                return (T)ExtensionIdConverter.toStringList(this.getExtensionFeatures());
            }
            case "summary": {
                return (T)this.getSummary();
            }
            case "description": {
                return (T)this.getDescription();
            }
            case "author": 
            case "authors": {
                return (T)this.getAuthors();
            }
            case "category": {
                return (T)this.getCategory();
            }
            case "license": 
            case "licenses": {
                return (T)this.getLicenses();
            }
            case "name": {
                return (T)this.getName();
            }
            case "type": {
                return (T)this.getType();
            }
            case "website": {
                return (T)this.getWebSite();
            }
            case "namespaces": 
            case "allowednamespace": 
            case "allowednamespaces": {
                return (T)this.getAllowedNamespaces();
            }
            case "scm": {
                return (T)this.getScm();
            }
            case "repositories": {
                return (T)this.getRepositories();
            }
            case "properties": {
                return (T)this.getProperties();
            }
        }
        return this.getProperty(fieldName);
    }

    @Override
    public ExtensionId getId() {
        return this.id;
    }

    protected void setId(ExtensionId id) {
        this.id = id;
    }

    @Override
    @Deprecated
    public Collection<String> getFeatures() {
        return this.features != null ? this.features : Collections.emptyList();
    }

    @Override
    @Deprecated
    public void setFeatures(Collection<String> features) {
        ArrayList<ExtensionId> extensionFeatures = new ArrayList<ExtensionId>(features.size());
        for (String feature : features) {
            extensionFeatures.add(new ExtensionId(feature, this.getId().getVersion()));
        }
        this.setExtensionFeatures(extensionFeatures);
    }

    @Override
    @Deprecated
    public void addFeature(String feature) {
        this.addExtensionFeature(new ExtensionId(feature, this.getId().getVersion()));
    }

    @Override
    public Collection<ExtensionId> getExtensionFeatures() {
        return this.featuresMap != null ? this.featuresMap.values() : Collections.emptyList();
    }

    @Override
    public ExtensionId getExtensionFeature(String featureId) {
        ExtensionId feature = null;
        if (this.featuresMap != null) {
            feature = this.featuresMap.get(featureId);
        }
        if (feature == null && featureId.equals(this.getId().getId())) {
            feature = this.getId();
        }
        return feature;
    }

    @Override
    public void setExtensionFeatures(Collection<ExtensionId> features) {
        LinkedHashMap<String, ExtensionId> map = new LinkedHashMap<String, ExtensionId>();
        for (ExtensionId feature : features) {
            map.put(feature.getId(), feature);
        }
        this.setFeatureMap(map);
    }

    @Override
    public void addExtensionFeature(ExtensionId feature) {
        LinkedHashMap<String, ExtensionId> map = this.featuresMap != null ? new LinkedHashMap<String, ExtensionId>(this.featuresMap) : new LinkedHashMap();
        map.put(feature.getId(), feature);
        this.setFeatureMap(map);
    }

    private void setFeatureMap(Map<String, ExtensionId> map) {
        this.featuresMap = Collections.unmodifiableMap(map);
        LinkedHashSet<String> list = new LinkedHashSet<String>(this.featuresMap.size());
        for (ExtensionId extensionId : this.featuresMap.values()) {
            list.add(extensionId.getId());
        }
        this.features = Collections.unmodifiableSet(list);
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Collection<ExtensionLicense> getLicenses() {
        return this.licenses != null ? this.licenses : Collections.emptyList();
    }

    @Override
    public void setLicenses(Collection<ExtensionLicense> licenses) {
        this.licenses = Collections.unmodifiableList(new ArrayList<ExtensionLicense>(licenses));
    }

    @Override
    public void addLicense(ExtensionLicense license) {
        ArrayList<ExtensionLicense> newLicenses = new ArrayList<ExtensionLicense>(this.getLicenses());
        newLicenses.add(license);
        this.licenses = Collections.unmodifiableList(newLicenses);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public List<ExtensionAuthor> getAuthors() {
        return this.authors != null ? this.authors : Collections.emptyList();
    }

    @Override
    public void setAuthors(Collection<? extends ExtensionAuthor> authors) {
        this.authors = Collections.unmodifiableList(new ArrayList<ExtensionAuthor>(authors));
    }

    @Override
    public void addAuthor(ExtensionAuthor author) {
        ArrayList<ExtensionAuthor> newAuthors = new ArrayList<ExtensionAuthor>(this.getAuthors());
        newAuthors.add(author);
        this.authors = Collections.unmodifiableList(newAuthors);
    }

    @Override
    public String getWebSite() {
        return this.website;
    }

    @Override
    public void setWebsite(String website) {
        this.website = website;
    }

    @Override
    public Collection<String> getAllowedNamespaces() {
        return this.allowedNamespaces;
    }

    @Override
    public void addAllowedNamespace(String namespace) {
        LinkedHashSet<String> newNamespaces = this.allowedNamespaces != null ? new LinkedHashSet<String>(this.allowedNamespaces) : new LinkedHashSet();
        newNamespaces.add(namespace);
        this.allowedNamespaces = Collections.unmodifiableSet(newNamespaces);
    }

    @Override
    public void setAllowedNamespaces(Collection<String> namespaces) {
        this.allowedNamespaces = namespaces != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(namespaces)) : null;
    }

    @Override
    public void addDependency(ExtensionDependency dependency) {
        ArrayList<ExtensionDependency> newDependencies = new ArrayList<ExtensionDependency>(this.getDependencies());
        newDependencies.add(dependency);
        this.dependencies = Collections.unmodifiableList(newDependencies);
    }

    public List<ExtensionDependency> getDependencies() {
        return this.dependencies != null ? this.dependencies : Collections.emptyList();
    }

    @Override
    public void setDependencies(Collection<? extends ExtensionDependency> dependencies) {
        this.dependencies = dependencies != null ? Collections.unmodifiableList(new ArrayList<ExtensionDependency>(dependencies)) : null;
    }

    @Override
    public void addManagedDependency(ExtensionDependency managedDependency) {
        ArrayList<ExtensionDependency> newManagedDependencies = new ArrayList<ExtensionDependency>(this.getManagedDependencies());
        newManagedDependencies.add(managedDependency);
        this.managedDependencies = Collections.unmodifiableList(newManagedDependencies);
    }

    public List<ExtensionDependency> getManagedDependencies() {
        return this.managedDependencies != null ? this.managedDependencies : Collections.emptyList();
    }

    @Override
    public void setManagedDependencies(Collection<? extends ExtensionDependency> managedDependencies) {
        this.managedDependencies = managedDependencies != null ? Collections.unmodifiableList(new ArrayList<ExtensionDependency>(managedDependencies)) : null;
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(ExtensionRepository repository) {
        this.repository = repository;
    }

    @Override
    public ExtensionScm getScm() {
        return this.scm;
    }

    @Override
    public void setScm(ExtensionScm scm) {
        this.scm = scm;
    }

    @Override
    public ExtensionIssueManagement getIssueManagement() {
        return this.issueManagement;
    }

    @Override
    public void setIssueManagement(ExtensionIssueManagement issueManagement) {
        this.issueManagement = issueManagement;
    }

    @Override
    public ExtensionFile getFile() {
        return this.file;
    }

    protected void setFile(ExtensionFile file) {
        this.file = file;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    @Unstable
    public void setCategory(String categrory) {
        this.category = categrory;
    }

    @Override
    public Collection<ExtensionRepositoryDescriptor> getRepositories() {
        return this.repositories != null ? this.repositories : Collections.emptyList();
    }

    @Override
    public void setRepositories(Collection<? extends ExtensionRepositoryDescriptor> repositories) {
        this.repositories = repositories != null ? Collections.unmodifiableList(new ArrayList<ExtensionRepositoryDescriptor>(repositories)) : null;
    }

    @Override
    public void addRepository(ExtensionRepositoryDescriptor repository) {
        ArrayList<ExtensionRepositoryDescriptor> newrepositories = new ArrayList<ExtensionRepositoryDescriptor>(this.getRepositories());
        newrepositories.add(repository);
        this.repositories = Collections.unmodifiableList(newrepositories);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    @Override
    public <T> T getProperty(String key) {
        return (T)this.getProperties().get(key);
    }

    @Override
    public <T> T getProperty(String key, T def) {
        return (T)(this.getProperties().containsKey(key) ? this.getProperties().get(key) : def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putProperty(String key, Object value) {
        ReentrantLock reentrantLock = this.propertiesLock;
        synchronized (reentrantLock) {
            LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>(this.getProperties());
            newProperties.put(key, value);
            this.properties = Collections.unmodifiableMap(newProperties);
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T removeProperty(String key) {
        Object previous;
        ReentrantLock reentrantLock = this.propertiesLock;
        synchronized (reentrantLock) {
            LinkedHashMap<String, Object> newProperties = new LinkedHashMap<String, Object>(this.getProperties());
            previous = newProperties.remove(key);
            this.properties = Collections.unmodifiableMap(newProperties);
        }
        return (T)previous;
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Extension && this.getId().equals(((Extension)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Extension o) {
        if (o == null) {
            return -1;
        }
        Integer comparizon = AbstractExtension.compareTo(this, o);
        if (comparizon != null) {
            return comparizon;
        }
        comparizon = AbstractExtension.compareTo(o, this);
        if (comparizon != null) {
            return comparizon;
        }
        return ObjectUtils.compare((Comparable)this.getId(), (Comparable)o.getId());
    }

    private static Integer compareTo(Extension e1, Extension e2) {
        ExtensionId feature = e2.getExtensionFeature(e1.getId().getId());
        if (feature != null) {
            return ObjectUtils.compare((Comparable)e1.getId().getVersion(), (Comparable)feature.getVersion());
        }
        for (ExtensionId feature1 : e1.getExtensionFeatures()) {
            feature = e2.getExtensionFeature(feature1.getId());
            if (feature == null) continue;
            return ObjectUtils.compare((Comparable)feature1.getVersion(), (Comparable)feature.getVersion());
        }
        return null;
    }
}

