/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Marker;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.namespace.NamespaceNotAllowedException;
import org.xwiki.component.namespace.NamespaceValidator;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.DefaultExtensionDependency;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.internal.ExtensionUtils;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.internal.AbstractExtensionPlanJob;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanAction;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanNode;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlanTree;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.version.IncompatibleVersionConstraintException;
import org.xwiki.extension.version.VersionConstraint;

public abstract class AbstractInstallPlanJob<R extends ExtensionRequest>
extends AbstractExtensionPlanJob<R> {
    @Inject
    protected ExtensionRepositoryManager repositoryManager;
    @Inject
    protected CoreExtensionRepository coreExtensionRepository;
    @Inject
    protected NamespaceValidator namespaceResolver;
    protected Map<String, Map<String, ModifableExtensionPlanNode>> extensionsNodeCache = new HashMap<String, Map<String, ModifableExtensionPlanNode>>();

    protected void setExtensionTree(DefaultExtensionPlanTree extensionTree) {
        this.extensionTree = extensionTree;
        ((DefaultExtensionPlan)this.status).setTree(this.extensionTree);
    }

    protected void addExtensionToProcess(Map<ExtensionId, Collection<String>> extensionsByNamespace, ExtensionId extensionId, String namespace) {
        Collection<Object> namespaces;
        if (extensionsByNamespace.containsKey(extensionId) && namespace != null) {
            namespaces = extensionsByNamespace.get(extensionId);
        } else {
            namespaces = namespace == null ? null : new HashSet();
            extensionsByNamespace.put(extensionId, namespaces);
        }
        if (namespaces != null) {
            namespaces.add(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Map<ExtensionId, Collection<String>> extensionsByNamespace) throws Exception {
        this.progressManager.pushLevelProgress(extensionsByNamespace.size(), (Object)this);
        try {
            for (Map.Entry<ExtensionId, Collection<String>> entry : extensionsByNamespace.entrySet()) {
                this.progressManager.startStep((Object)this);
                ExtensionId extensionId = entry.getKey();
                Collection<String> namespaces = entry.getValue();
                if (namespaces != null) {
                    this.progressManager.pushLevelProgress(namespaces.size(), (Object)this);
                    try {
                        for (String namespace : namespaces) {
                            this.progressManager.startStep((Object)this);
                            this.installExtension(extensionId, namespace, this.extensionTree);
                        }
                        continue;
                    }
                    finally {
                        this.progressManager.popLevelProgress((Object)this);
                        continue;
                    }
                }
                this.installExtension(extensionId, null, this.extensionTree);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private ModifableExtensionPlanNode getExtensionNode(String id, String namespace) {
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        ModifableExtensionPlanNode node = null;
        if (extensionsById != null && (node = extensionsById.get(namespace)) == null && namespace != null) {
            node = extensionsById.get(null);
        }
        return node;
    }

    private void addExtensionNode(ModifableExtensionPlanNode node) {
        ModifableExtensionPlanNode existingNode;
        String id = node.getAction().getExtension().getId().getId();
        Map<String, ModifableExtensionPlanNode> extensionsById = this.extensionsNodeCache.get(id);
        if (extensionsById == null) {
            extensionsById = new HashMap<String, ModifableExtensionPlanNode>();
            this.extensionsNodeCache.put(id, extensionsById);
        }
        if ((existingNode = extensionsById.get(node.getAction().getNamespace())) != null) {
            existingNode.set(node);
            for (ModifableExtensionPlanNode duplicate : existingNode.duplicates) {
                duplicate.set(node);
            }
            existingNode.duplicates.add(node);
        } else {
            extensionsById.put(node.getAction().getNamespace(), node);
        }
    }

    protected void installExtension(ExtensionId extensionId, String namespace, DefaultExtensionPlanTree parentBranch) throws InstallException {
        try {
            this.installExtension(extensionId, false, namespace, parentBranch);
        }
        catch (ResolveException e) {
            throw new InstallException("An unexpected exception has been raised", e);
        }
    }

    protected void installExtension(ExtensionId extensionId, boolean dependency, String namespace, DefaultExtensionPlanTree parentBranch) throws InstallException, ResolveException {
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVE_NAMESPACE, "Resolving extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVE, "Resolving extension [{}] on all namespaces", (Object)extensionId);
            }
        }
        if (this.checkExistingPlanNodeExtension(extensionId, true, namespace)) {
            return;
        }
        this.checkCoreExtension(extensionId.getId());
        ModifableExtensionPlanNode node = this.installExtension(extensionId, dependency, namespace);
        this.addExtensionNode(node);
        parentBranch.add(node);
    }

    private boolean checkCoreDependency(ExtensionDependency extensionDependency, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        CoreExtension coreExtension = this.coreExtensionRepository.getCoreExtension(extensionDependency.getId());
        if (coreExtension != null) {
            ExtensionId feature = coreExtension.getExtensionFeature(extensionDependency.getId());
            if (!extensionDependency.getVersionConstraint().isCompatible(feature.getVersion())) {
                throw new InstallException("Dependency [" + extensionDependency + "] is not compatible with core extension feature [" + feature + "] ([" + coreExtension + "])");
            }
            if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                this.logger.debug("There is already a core extension feature [{}] ([{}]) covering extension dependency [{}]", new Object[]{feature, coreExtension, extensionDependency});
            }
            ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, extensionDependency.getVersionConstraint());
            node.setAction(new DefaultExtensionPlanAction(coreExtension, null, ExtensionPlanAction.Action.NONE, null, true));
            parentBranch.add(node);
            return true;
        }
        return false;
    }

    private VersionConstraint checkExistingPlanNodeDependency(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch, VersionConstraint previousVersionConstraint) throws InstallException {
        VersionConstraint versionConstraint = previousVersionConstraint;
        ModifableExtensionPlanNode existingNode = this.getExtensionNode(extensionDependency.getId(), namespace);
        if (existingNode != null) {
            if (versionConstraint.isCompatible(existingNode.getAction().getExtension().getId().getVersion())) {
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, existingNode);
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            if (existingNode.versionConstraint != null) {
                try {
                    versionConstraint = versionConstraint.merge(existingNode.versionConstraint);
                }
                catch (IncompatibleVersionConstraintException e) {
                    throw new InstallException("Dependency [" + extensionDependency + "] is incompatible with current constaint [" + existingNode.versionConstraint + "]", e);
                }
            } else {
                throw new InstallException("Dependency [" + extensionDependency + "] incompatible with extension [" + existingNode.getAction().getExtension() + "]");
            }
        }
        return versionConstraint;
    }

    private boolean checkExistingPlanNodeExtension(Extension extension, String namespace) throws InstallException {
        if (this.checkExistingPlanNodeExtension(extension.getId(), true, namespace)) {
            return true;
        }
        for (ExtensionId feature : extension.getExtensionFeatures()) {
            this.checkExistingPlanNodeExtension(feature, false, namespace);
        }
        return false;
    }

    private boolean checkExistingPlanNodeExtension(ExtensionId extensionId, boolean isId, String namespace) throws InstallException {
        ModifableExtensionPlanNode existingNode = this.getExtensionNode(extensionId.getId(), namespace);
        if (existingNode != null) {
            if (isId && existingNode.getAction().getExtension().getId().equals(extensionId)) {
                return true;
            }
            if (existingNode.versionConstraint != null && !existingNode.versionConstraint.isCompatible(extensionId.getVersion())) {
                throw new InstallException(String.format("Extension feature [%s] is incompatible with existing constraint [%s]", extensionId, existingNode.versionConstraint));
            }
        }
        return false;
    }

    private ExtensionDependency checkInstalledDependency(ExtensionDependency extensionDependency, VersionConstraint versionConstraint, String namespace, List<ModifableExtensionPlanNode> parentBranch) throws InstallException {
        InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(extensionDependency.getId(), namespace);
        ExtensionDependency targetDependency = extensionDependency;
        if (installedExtension != null) {
            VersionConstraint mergedVersionContraint;
            ExtensionId feature;
            if (installedExtension.isValid(namespace) && versionConstraint.isCompatible((feature = installedExtension.getExtensionFeature(extensionDependency.getId())).getVersion())) {
                if (((ExtensionRequest)this.getRequest()).isVerbose()) {
                    this.logger.debug("There is already an installed extension [{}] covering extension dependency [{}]", (Object)installedExtension.getId(), (Object)extensionDependency);
                }
                ModifableExtensionPlanNode node = new ModifableExtensionPlanNode(extensionDependency, versionConstraint);
                node.setAction(new DefaultExtensionPlanAction(installedExtension, null, ExtensionPlanAction.Action.NONE, namespace, installedExtension.isDependency(namespace)));
                this.addExtensionNode(node);
                parentBranch.add(node);
                return null;
            }
            if (namespace != null && installedExtension.isInstalled(null) && !((ExtensionRequest)this.getRequest()).isRootModificationsAllowed()) {
                throw new InstallException(String.format("Dependency [%s] is incompatible with installed root extension [%s]", extensionDependency, installedExtension.getId()));
            }
            try {
                if (installedExtension.isInstalled(null)) {
                    Map<String, Collection<InstalledExtension>> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId());
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(null), extensionDependency.getId(), versionConstraint);
                    if (namespace != null) {
                        mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies.get(namespace), extensionDependency.getId(), mergedVersionContraint);
                    }
                } else {
                    Collection<InstalledExtension> backwardDependencies = this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace);
                    mergedVersionContraint = this.mergeVersionConstraints(backwardDependencies, extensionDependency.getId(), versionConstraint);
                }
            }
            catch (IncompatibleVersionConstraintException e) {
                throw new InstallException("Provided depency is incompatible with already installed extensions", e);
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to resolve backward dependencies", e);
            }
            if (mergedVersionContraint != versionConstraint) {
                targetDependency = new DefaultExtensionDependency(extensionDependency, mergedVersionContraint);
            }
        }
        return targetDependency;
    }

    private void installExtensionDependency(ExtensionDependency extensionDependency, String namespace, List<ModifableExtensionPlanNode> parentBranch, Map<String, ExtensionDependency> managedDependencies) throws InstallException, IncompatibleVersionConstraintException, ResolveException {
        if (extensionDependency.getVersionConstraint() == null) {
            throw new InstallException("Dependency [" + extensionDependency + "] does not have any version constraint");
        }
        if (((ExtensionRequest)this.getRequest()).isVerbose()) {
            if (namespace != null) {
                this.logger.info((Marker)LOG_RESOLVEDEPENDENCY_NAMESPACE, "Resolving extension dependency [{}] on namespace [{}]", (Object)extensionDependency, (Object)namespace);
            } else {
                this.logger.info((Marker)LOG_RESOLVEDEPENDENCY, "Resolving extension dependency [{}] on all namespaces", (Object)extensionDependency);
            }
        }
        VersionConstraint versionConstraint = extensionDependency.getVersionConstraint();
        if (this.checkCoreDependency(extensionDependency, parentBranch)) {
            return;
        }
        if (namespace != null && ((ExtensionRequest)this.getRequest()).isRootModificationsAllowed() && this.hasIncompatileRootDependency(extensionDependency)) {
            this.installExtensionDependency(extensionDependency, null, parentBranch, managedDependencies);
            return;
        }
        if ((versionConstraint = this.checkExistingPlanNodeDependency(extensionDependency, namespace, parentBranch, versionConstraint)) == null) {
            return;
        }
        ExtensionDependency targetDependency = this.checkInstalledDependency(extensionDependency, versionConstraint, namespace, parentBranch);
        if (targetDependency == null) {
            return;
        }
        if (namespace == null) {
            versionConstraint = this.mergeBackwardDependenciesVersionConstraints(targetDependency.getId(), namespace, targetDependency.getVersionConstraint());
            targetDependency = new DefaultExtensionDependency(targetDependency, versionConstraint);
        }
        ModifableExtensionPlanNode node = this.installExtensionDependency(targetDependency, true, namespace, managedDependencies);
        node.versionConstraint = versionConstraint;
        this.addExtensionNode(node);
        parentBranch.add(node);
    }

    private ModifableExtensionPlanNode installExtensionDependency(ExtensionDependency targetDependency, boolean dependency, String namespace, Map<String, ExtensionDependency> managedDependencies) throws InstallException {
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            Extension extension = this.resolveExtension(targetDependency);
            this.progressManager.startStep((Object)this);
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(extension, dependency, namespace, targetDependency, managedDependencies);
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException(String.format("Failed to create an install plan for extension dependency [%s]", targetDependency), e);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private VersionConstraint mergeVersionConstraints(Collection<? extends Extension> extensions, String feature, VersionConstraint previousMergedVersionContraint) throws IncompatibleVersionConstraintException {
        VersionConstraint mergedVersionContraint = previousMergedVersionContraint;
        if (extensions != null) {
            for (Extension extension : extensions) {
                ExtensionDependency dependency = this.getDependency(extension, feature);
                if (dependency == null) continue;
                if (mergedVersionContraint == null) {
                    mergedVersionContraint = dependency.getVersionConstraint();
                    continue;
                }
                mergedVersionContraint = mergedVersionContraint.merge(dependency.getVersionConstraint());
            }
        }
        return mergedVersionContraint;
    }

    private ExtensionDependency getDependency(Extension extension, String dependencyId) {
        for (ExtensionDependency dependency : extension.getDependencies()) {
            if (!dependency.getId().equals(dependencyId)) continue;
            return dependency;
        }
        return null;
    }

    private ModifableExtensionPlanNode installExtension(ExtensionId extensionId, boolean dependency, String namespace) throws InstallException {
        if (namespace != null && this.checkRootExtension(extensionId.getId())) {
            return this.installExtension(extensionId, dependency, null);
        }
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            Extension extension = this.resolveExtension(extensionId);
            this.progressManager.startStep((Object)this);
            try {
                ModifableExtensionPlanNode modifableExtensionPlanNode = this.installExtension(extension, dependency, namespace, null, Collections.emptyMap());
                return modifableExtensionPlanNode;
            }
            catch (Exception e) {
                throw new InstallException("Failed to resolve extension", e);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private Extension resolveExtension(ExtensionId extensionId) throws InstallException {
        Extension extension = this.localExtensionRepository.getLocalExtension(extensionId);
        if (extension == null) {
            this.logger.debug("Can't find extension in local repository, trying to download it.");
            try {
                extension = this.repositoryManager.resolve(extensionId);
            }
            catch (ResolveException e1) {
                throw new InstallException(String.format("Failed to resolve extension [%s]", extensionId), e1);
            }
        }
        return extension;
    }

    private Extension resolveExtension(ExtensionDependency extensionDependency) throws InstallException {
        Extension extension;
        try {
            extension = this.localExtensionRepository.resolve(extensionDependency);
        }
        catch (ResolveException e) {
            this.logger.debug("Can't find extension dependency in local repository, trying to download it.", (Throwable)e);
            try {
                extension = this.repositoryManager.resolve(extensionDependency);
            }
            catch (ResolveException e1) {
                throw new InstallException(String.format("Failed to resolve extension dependency [%s]", extensionDependency), e1);
            }
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModifableExtensionPlanNode installExtension(Extension extension, boolean dependency, String namespace, ExtensionDependency initialDependency, Map<String, ExtensionDependency> managedDependencies) throws InstallException, ResolveException, IncompatibleVersionConstraintException, UninstallException, NamespaceNotAllowedException {
        boolean allowed = this.namespaceResolver.isAllowed(extension.getAllowedNamespaces(), namespace);
        if (!allowed) {
            if (namespace != null && ((ExtensionRequest)this.getRequest()).isRootModificationsAllowed()) {
                return this.installExtension(extension, dependency, null, initialDependency, managedDependencies);
            }
            throw new NamespaceNotAllowedException(String.format("Extension [%s] is not allowed on namespace [%s]. Allowed namespaces are: %s", extension.getId(), namespace, extension.getAllowedNamespaces()));
        }
        this.checkExistingPlanNodeExtension(extension, namespace);
        if (namespace != null && this.checkRootExtension(extension)) {
            return this.installExtension(extension, dependency, null, initialDependency, managedDependencies);
        }
        extension = this.checkInstalledExtension(extension, namespace);
        this.checkCoreExtension(extension);
        this.progressManager.pushLevelProgress(6, (Object)this);
        try {
            ExtensionHandler extensionHandler;
            this.progressManager.startStep((Object)this);
            try {
                extensionHandler = (ExtensionHandler)this.componentManager.getInstance(ExtensionHandler.class, extension.getType());
            }
            catch (ComponentLookupException e) {
                throw new InstallException(String.format("Unsupported type [%s]", extension.getType()), e);
            }
            this.progressManager.startStep((Object)this);
            extensionHandler.checkInstall(extension, namespace, this.getRequest());
            this.progressManager.startStep((Object)this);
            Set<InstalledExtension> previousExtensions = this.getReplacedInstalledExtensions(extension, namespace);
            this.progressManager.startStep((Object)this);
            for (InstalledExtension previousExtension : new ArrayList<InstalledExtension>(previousExtensions)) {
                if (previousExtension.isInstalled(namespace) && previousExtension.getId().getId().equals(extension.getId().getId())) continue;
                if (namespace == null && previousExtension.getNamespaces() != null) {
                    for (String previousNamespace : previousExtension.getNamespaces()) {
                        this.uninstallExtension(previousExtension, previousNamespace, (Collection<ExtensionPlanNode>)this.extensionTree, false);
                        previousExtensions.remove(previousExtension);
                    }
                    continue;
                }
                this.uninstallExtension(previousExtension, namespace, (Collection<ExtensionPlanNode>)this.extensionTree, false);
            }
            this.progressManager.startStep((Object)this);
            Collection<ExtensionDependency> dependencies = extension.getDependencies();
            ArrayList<ModifableExtensionPlanNode> children = null;
            if (!dependencies.isEmpty()) {
                this.progressManager.pushLevelProgress(dependencies.size() + 1, (Object)this);
                try {
                    children = new ArrayList<ModifableExtensionPlanNode>();
                    for (ExtensionDependency extensionDependency : extension.getDependencies()) {
                        this.progressManager.startStep((Object)this);
                        extensionDependency = ExtensionUtils.getDependency(extensionDependency, managedDependencies, extension);
                        this.installExtensionDependency(extensionDependency, namespace, children, ExtensionUtils.append(managedDependencies, extension));
                    }
                }
                finally {
                    this.progressManager.popLevelProgress((Object)this);
                }
            }
            this.progressManager.startStep((Object)this);
            ModifableExtensionPlanNode node = initialDependency != null ? new ModifableExtensionPlanNode(initialDependency, initialDependency.getVersionConstraint()) : new ModifableExtensionPlanNode();
            node.setChildren(children);
            ExtensionPlanAction.Action action = !previousExtensions.isEmpty() ? (extension.compareTo(previousExtensions.iterator().next()) < 0 ? ExtensionPlanAction.Action.DOWNGRADE : ExtensionPlanAction.Action.UPGRADE) : (extension instanceof InstalledExtension ? ExtensionPlanAction.Action.REPAIR : ExtensionPlanAction.Action.INSTALL);
            node.setAction(new DefaultExtensionPlanAction(extension, previousExtensions, action, namespace, dependency));
            ModifableExtensionPlanNode modifableExtensionPlanNode = node;
            return modifableExtensionPlanNode;
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private Extension checkInstalledExtension(Extension extension, String namespace) throws InstallException {
        InstalledExtension installedExtension;
        if (namespace != null) {
            this.checkRootExtension(extension);
        }
        if ((installedExtension = this.installedExtensionRepository.getInstalledExtension(extension.getId())) != null && installedExtension.isInstalled(namespace)) {
            if (installedExtension.isValid(namespace)) {
                throw new InstallException(String.format("Extension [%s] is already installed on namespace [%s]", extension.getId(), namespace));
            }
            return installedExtension;
        }
        return extension;
    }

    private boolean checkRootExtension(Extension extension) throws InstallException {
        boolean isRootExtension = this.checkRootExtension(extension.getId().getId());
        for (ExtensionId feature : extension.getExtensionFeatures()) {
            isRootExtension |= this.checkRootExtension(feature.getId());
        }
        return isRootExtension;
    }

    private boolean checkRootExtension(String feature) throws InstallException {
        InstalledExtension rootExtension = this.installedExtensionRepository.getInstalledExtension(feature, null);
        if (rootExtension != null) {
            if (!((ExtensionRequest)this.getRequest()).isRootModificationsAllowed()) {
                throw new InstallException(String.format("An extension with feature [%s] is already installed on root namespace ([%s])", feature, rootExtension.getId()));
            }
            return true;
        }
        return false;
    }

    private boolean hasIncompatileRootDependency(ExtensionDependency extensionDependency) {
        InstalledExtension rootExtension = this.installedExtensionRepository.getInstalledExtension(extensionDependency.getId(), null);
        return rootExtension != null && !extensionDependency.isCompatible(rootExtension);
    }

    private void checkCoreExtension(Extension extension) throws InstallException {
        for (ExtensionId feature : extension.getExtensionFeatures()) {
            this.checkCoreExtension(feature.getId());
        }
    }

    private void checkCoreExtension(String feature) throws InstallException {
        if (this.coreExtensionRepository.exists(feature)) {
            throw new InstallException(String.format("There is already a core covering feature [%s]", feature));
        }
    }

    private Set<InstalledExtension> getReplacedInstalledExtensions(Extension extension, String namespace) throws IncompatibleVersionConstraintException, ResolveException, InstallException {
        if (namespace != null) {
            this.checkRootExtension(extension.getId().getId());
        }
        LinkedHashSet<InstalledExtension> previousExtensions = new LinkedHashSet<InstalledExtension>();
        Set<InstalledExtension> installedExtensions = this.getInstalledExtensions(extension.getId().getId(), namespace);
        VersionConstraint versionConstraint = this.checkReplacedInstalledExtensions(installedExtensions, extension.getId(), namespace, null);
        previousExtensions.addAll(installedExtensions);
        for (ExtensionId feature : extension.getExtensionFeatures()) {
            if (namespace != null) {
                this.checkRootExtension(feature.getId());
            }
            installedExtensions = this.getInstalledExtensions(feature.getId(), namespace);
            versionConstraint = this.checkReplacedInstalledExtensions(installedExtensions, feature, namespace, versionConstraint);
            previousExtensions.addAll(installedExtensions);
        }
        if (extension instanceof InstalledExtension) {
            previousExtensions.remove(extension);
        }
        return previousExtensions;
    }

    private VersionConstraint mergeBackwardDependenciesVersionConstraints(String feature, String namespace, VersionConstraint versionConstraint) throws IncompatibleVersionConstraintException, ResolveException {
        Set<InstalledExtension> installedExtensions = this.getInstalledExtensions(feature, namespace);
        return this.mergeBackwardDependenciesVersionConstraints(installedExtensions, feature, namespace, versionConstraint);
    }

    private VersionConstraint mergeBackwardDependenciesVersionConstraints(Collection<InstalledExtension> installedExtensions, String feature, String namespace, VersionConstraint versionConstraint) throws IncompatibleVersionConstraintException, ResolveException {
        if (installedExtensions.isEmpty()) {
            return versionConstraint;
        }
        Map<String, Set<InstalledExtension>> backwardDependencies = this.getBackwardDependencies(installedExtensions, namespace);
        for (Map.Entry<String, Set<InstalledExtension>> entry : backwardDependencies.entrySet()) {
            versionConstraint = this.mergeVersionConstraints((Collection<Extension>)entry.getValue(), feature, versionConstraint);
        }
        return versionConstraint;
    }

    private VersionConstraint checkReplacedInstalledExtensions(Collection<InstalledExtension> installedExtensions, ExtensionId feature, String namespace, VersionConstraint versionConstraint) throws IncompatibleVersionConstraintException, ResolveException {
        if (installedExtensions.isEmpty()) {
            return versionConstraint;
        }
        Map<String, Set<InstalledExtension>> backwardDependencies = this.getBackwardDependencies(installedExtensions, namespace);
        for (Map.Entry<String, Set<InstalledExtension>> entry : backwardDependencies.entrySet()) {
            versionConstraint = this.mergeVersionConstraints((Collection<Extension>)entry.getValue(), feature.getId(), versionConstraint);
            if (versionConstraint == null || versionConstraint.isCompatible(feature.getVersion())) continue;
            throw new IncompatibleVersionConstraintException(String.format("The extension with feature [%s] is not compatible with existing backward dependency constraint [%s]", feature, versionConstraint));
        }
        return versionConstraint;
    }

    private Map<String, Set<InstalledExtension>> getBackwardDependencies(Collection<InstalledExtension> installedExtensions, String namespace) throws ResolveException {
        LinkedHashMap<String, Set<InstalledExtension>> backwardDependencies = new LinkedHashMap<String, Set<InstalledExtension>>();
        for (InstalledExtension installedExtension : installedExtensions) {
            Set<InstalledExtension> namespaceBackwardDependencies;
            if (namespace == null) {
                for (Map.Entry entry : this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId()).entrySet()) {
                    namespaceBackwardDependencies = (LinkedHashSet<InstalledExtension>)backwardDependencies.get(entry.getKey());
                    if (namespaceBackwardDependencies == null) {
                        namespaceBackwardDependencies = new LinkedHashSet<InstalledExtension>();
                        backwardDependencies.put((String)entry.getKey(), namespaceBackwardDependencies);
                    }
                    namespaceBackwardDependencies.addAll((Collection)entry.getValue());
                }
                continue;
            }
            for (InstalledExtension installedExtension2 : this.installedExtensionRepository.getBackwardDependencies(installedExtension.getId().getId(), namespace)) {
                namespaceBackwardDependencies = (Set)backwardDependencies.get(namespace);
                if (namespaceBackwardDependencies == null) {
                    namespaceBackwardDependencies = new LinkedHashSet();
                    backwardDependencies.put(namespace, namespaceBackwardDependencies);
                }
                namespaceBackwardDependencies.add(installedExtension2);
            }
        }
        return backwardDependencies;
    }

    private Set<InstalledExtension> getInstalledExtensions(String feature, String namespace) {
        LinkedHashSet<InstalledExtension> installedExtensions = new LinkedHashSet<InstalledExtension>();
        this.getInstalledExtensions(feature, namespace, installedExtensions);
        return installedExtensions;
    }

    private void getInstalledExtensions(String feature, String namespace, Set<InstalledExtension> installedExtensions) {
        if (namespace == null) {
            this.getInstalledExtensions(feature, installedExtensions);
        } else {
            InstalledExtension installedExtension = this.installedExtensionRepository.getInstalledExtension(feature, namespace);
            if (installedExtension != null) {
                installedExtensions.add(installedExtension);
            }
        }
    }

    private void getInstalledExtensions(String feature, Set<InstalledExtension> installedExtensions) {
        block0: for (InstalledExtension installedExtension : this.installedExtensionRepository.getInstalledExtensions()) {
            if (installedExtension.getId().getId().equals(feature)) {
                installedExtensions.add(installedExtension);
                continue;
            }
            for (ExtensionId installedFeature : installedExtension.getExtensionFeatures()) {
                if (!installedFeature.getId().equals(feature)) continue;
                installedExtensions.add(installedExtension);
                continue block0;
            }
        }
    }

    protected static class ModifableExtensionPlanNode
    extends DefaultExtensionPlanNode {
        private final ExtensionDependency initialDependency;
        public VersionConstraint versionConstraint;
        public final List<ModifableExtensionPlanNode> duplicates = new ArrayList<ModifableExtensionPlanNode>();

        public ModifableExtensionPlanNode() {
            this.initialDependency = null;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, VersionConstraint versionConstraint) {
            this.initialDependency = initialDependency;
            this.versionConstraint = versionConstraint;
        }

        public ModifableExtensionPlanNode(ExtensionDependency initialDependency, ModifableExtensionPlanNode node) {
            this.initialDependency = initialDependency;
            this.set(node);
        }

        public void set(ModifableExtensionPlanNode node) {
            this.action = node.action;
            this.children = node.children;
        }

        @Override
        public VersionConstraint getInitialVersionConstraint() {
            return this.initialDependency != null ? this.initialDependency.getVersionConstraint() : null;
        }

        public void setAction(ExtensionPlanAction action) {
            this.action = action;
        }

        public void setChildren(Collection<? extends ExtensionPlanNode> children) {
            this.children = children;
        }
    }
}

