/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;

@Component
@Singleton
public class DefaultExtensionLicenseManager
implements ExtensionLicenseManager,
Initializable {
    private static final String ALIAS_PREFIX = ".alias=";
    private static final String LICENSE_PACKAGE = "extension.licenses";
    @Inject
    private Logger logger;
    private Map<String, ExtensionLicense> licenses = new ConcurrentHashMap<String, ExtensionLicense>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws InitializationException {
        Collection licenseURLs = ClasspathHelper.forPackage((String)LICENSE_PACKAGE, (ClassLoader[])new ClassLoader[0]);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(licenseURLs).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)LICENSE_PACKAGE))));
        for (String licenseFile : reflections.getResources(Pattern.compile(".*\\.license"))) {
            URL licenseUrl = this.getClass().getClassLoader().getResource(licenseFile);
            try {
                String path = this.decode(licenseUrl.getPath());
                String name = path.substring(path.lastIndexOf(47) + 1);
                name = name.substring(0, name.length() - ".license".length());
                try (InputStream is = licenseUrl.openStream();){
                    String line;
                    List<String> content = IOUtils.readLines((InputStream)is);
                    ArrayList<String> aliases = new ArrayList<String>();
                    aliases.add(name);
                    Iterator iterator = content.iterator();
                    while (iterator.hasNext() && (line = (String)iterator.next()).startsWith(ALIAS_PREFIX)) {
                        aliases.add(line.substring(ALIAS_PREFIX.length()));
                    }
                    content = content.subList(aliases.size() - 1, content.size());
                    ExtensionLicense license = new ExtensionLicense(name, content);
                    for (String alias : aliases) {
                        this.licenses.put(alias.toLowerCase(), license);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Failed to load license file at [" + licenseUrl + "]", (Throwable)e);
            }
        }
    }

    private String decode(String path) throws UnsupportedEncodingException {
        return URLDecoder.decode(path, "UTF-8");
    }

    @Override
    public List<ExtensionLicense> getLicenses() {
        return new ArrayList<ExtensionLicense>(this.licenses.values());
    }

    @Override
    public ExtensionLicense getLicense(String name) {
        return this.licenses.get(name.toLowerCase());
    }

    @Override
    public void addLicense(ExtensionLicense license) {
        this.licenses.put(license.getName().toLowerCase(), license);
    }
}

