/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.handler.ExtensionInitializer;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.InstalledExtensionRepository;

@Component
@Singleton
public class DefaultExtensionInitializer
implements ExtensionInitializer {
    @Inject
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Logger logger;

    @Override
    public void initialize() {
        this.initialize(null, null);
    }

    @Override
    public void initialize(String namespaceToLoad) {
        this.initialize(namespaceToLoad, null);
    }

    @Override
    public void initialize(String namespaceToInitialize, String type) {
        HashMap<String, Set<InstalledExtension>> initializedExtensions = new HashMap<String, Set<InstalledExtension>>();
        Collection<InstalledExtension> installedExtensions = namespaceToInitialize != null ? this.installedExtensionRepository.getInstalledExtensions(namespaceToInitialize) : this.installedExtensionRepository.getInstalledExtensions();
        for (InstalledExtension installedExtension : installedExtensions) {
            if (type != null && !type.equals(installedExtension.getType())) continue;
            try {
                this.initializeExtension(installedExtension, namespaceToInitialize, initializedExtensions);
            }
            catch (Throwable t) {
                this.logger.error("Failed to initialize local extension [{}]", (Object)installedExtension.getId(), (Object)t);
            }
        }
    }

    private void initializeExtension(InstalledExtension installedExtension, String namespaceToLoad, Map<String, Set<InstalledExtension>> initializedExtensions) throws ExtensionException {
        if (installedExtension.getNamespaces() != null) {
            if (namespaceToLoad == null) {
                for (String namespace : installedExtension.getNamespaces()) {
                    this.initializeExtensionInNamespace(installedExtension, namespace, initializedExtensions);
                }
            } else if (installedExtension.getNamespaces().contains(namespaceToLoad)) {
                this.initializeExtensionInNamespace(installedExtension, namespaceToLoad, initializedExtensions);
            }
        } else if (namespaceToLoad == null) {
            this.initializeExtensionInNamespace(installedExtension, null, initializedExtensions);
        }
    }

    private void initializeExtensionInNamespace(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> initializedExtensions) throws ExtensionException {
        if (!installedExtension.isValid(namespace)) {
            return;
        }
        Set<InstalledExtension> initializedExtensionsInNamespace = initializedExtensions.get(namespace);
        if (initializedExtensionsInNamespace == null) {
            initializedExtensionsInNamespace = new HashSet<InstalledExtension>();
            initializedExtensions.put(namespace, initializedExtensionsInNamespace);
        }
        if (!initializedExtensionsInNamespace.contains(installedExtension)) {
            this.initializeExtensionInNamespace(installedExtension, namespace, initializedExtensions, initializedExtensionsInNamespace);
        }
    }

    private void initializeExtensionInNamespace(InstalledExtension installedExtension, String namespace, Map<String, Set<InstalledExtension>> initializedExtensions, Set<InstalledExtension> initializedExtensionsInNamespace) throws ExtensionException {
        if (namespace != null && installedExtension.getNamespaces() == null) {
            this.initializeExtensionInNamespace(installedExtension, null, initializedExtensions);
        } else {
            for (ExtensionDependency dependency : installedExtension.getDependencies()) {
                if (this.coreExtensionRepository.exists(dependency.getId())) continue;
                InstalledExtension dependencyExtension = this.installedExtensionRepository.getInstalledExtension(dependency.getId(), namespace);
                if (dependencyExtension == installedExtension) {
                    throw new ExtensionException(String.format("Extension [] has itself as dependency ([]). It usually mean an extension is installed along with one of it's features.", installedExtension, dependency));
                }
                this.initializeExtensionInNamespace(dependencyExtension, namespace, initializedExtensions);
            }
            this.extensionHandlerManager.initialize(installedExtension, namespace);
            initializedExtensionsInNamespace.add(installedExtension);
        }
    }
}

