/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.xwiki.extension.ExtensionAuthor;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionIssueManagement;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionScm;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.stability.Unstable;

public interface Extension
extends Comparable<Extension> {
    public static final String FIELD_REPOSITORY = "repository";
    public static final String FIELD_ID = "id";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_FEATURE = "feature";
    public static final String FIELD_FEATURES = "features";
    public static final String FIELD_SUMMARY = "summary";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_AUTHOR = "author";
    public static final String FIELD_AUTHORS = "authors";
    public static final String FIELD_CATEGORY = "category";
    public static final String FIELD_LICENSE = "license";
    public static final String FIELD_LICENSES = "licenses";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_WEBSITE = "website";
    public static final String FIELD_ALLOWEDNAMESPACE = "allowednamespace";
    public static final String FIELD_ALLOWEDNAMESPACES = "allowednamespaces";
    public static final String FIELD_SCM = "scm";
    public static final String FIELD_REPOSITORIES = "repositories";
    public static final String FIELD_PROPERTIES = "properties";

    @Unstable
    public <T> T get(String var1);

    public ExtensionId getId();

    @Deprecated
    public Collection<String> getFeatures();

    default public Collection<ExtensionId> getExtensionFeatures() {
        Collection<String> features = this.getFeatures();
        ArrayList<ExtensionId> extensionFeatures = new ArrayList<ExtensionId>(features.size());
        for (String feature : features) {
            extensionFeatures.add(new ExtensionId(feature, this.getId().getVersion()));
        }
        return extensionFeatures;
    }

    default public ExtensionId getExtensionFeature(String featureId) {
        return this.getFeatures().contains(featureId) ? new ExtensionId(featureId, this.getId().getVersion()) : null;
    }

    public String getType();

    public String getName();

    public Collection<ExtensionLicense> getLicenses();

    public String getSummary();

    public String getDescription();

    public String getWebSite();

    public Collection<ExtensionAuthor> getAuthors();

    default public Collection<String> getAllowedNamespaces() {
        return Collections.emptyList();
    }

    public Collection<ExtensionDependency> getDependencies();

    default public Collection<ExtensionDependency> getManagedDependencies() {
        return Collections.emptyList();
    }

    public ExtensionFile getFile();

    public ExtensionRepository getRepository();

    public ExtensionScm getScm();

    public ExtensionIssueManagement getIssueManagement();

    @Unstable
    public String getCategory();

    public Collection<ExtensionRepositoryDescriptor> getRepositories();

    public Map<String, Object> getProperties();

    public <T> T getProperty(String var1);

    public <T> T getProperty(String var1, T var2);
}

