/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.maven;

import org.apache.maven.model.Model;
import org.xwiki.extension.AbstractExtension;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.internal.maven.MavenExtension;
import org.xwiki.extension.repository.ExtensionRepository;

public abstract class AbstractMavenExtension
extends AbstractExtension
implements MavenExtension {
    public static final String PKEY_MAVEN_MODEL = "maven.Model";
    public static final String PKEY_MAVEN_ARTIFACTID = "maven.artifactid";
    public static final String PKEY_MAVEN_GROUPID = "maven.groupid";

    public AbstractMavenExtension(ExtensionRepository repository, String groupId, String artifactId, String version, String type) {
        super(repository, new ExtensionId(groupId + ':' + artifactId, version), type);
        this.setMavenGroupId(groupId);
        this.setMavenArtifactId(artifactId);
    }

    public AbstractMavenExtension(ExtensionRepository repository, Extension extension) {
        super(repository, extension);
        if (extension instanceof MavenExtension) {
            MavenExtension mavenExtension = (MavenExtension)extension;
            this.setMavenArtifactId(mavenExtension.getMavenArtifactId());
            this.setMavenGroupId(mavenExtension.getMavenGroupId());
        }
    }

    @Override
    public String getMavenGroupId() {
        return (String)this.getProperty(PKEY_MAVEN_GROUPID);
    }

    public void setMavenGroupId(String groupId) {
        this.putProperty(PKEY_MAVEN_GROUPID, groupId);
    }

    @Override
    public String getMavenArtifactId() {
        return (String)this.getProperty(PKEY_MAVEN_ARTIFACTID);
    }

    public void setMavenArtifactId(String artifactId) {
        this.putProperty(PKEY_MAVEN_ARTIFACTID, artifactId);
    }

    public Model getMavenModel() {
        return (Model)this.getProperty(PKEY_MAVEN_MODEL);
    }
}

