/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.converter;

import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Scm;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.extension.DefaultExtensionAuthor;
import org.xwiki.extension.DefaultExtensionIssueManagement;
import org.xwiki.extension.DefaultExtensionScm;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.ExtensionLicenseManager;
import org.xwiki.extension.ExtensionScmConnection;
import org.xwiki.extension.internal.converter.ExtensionIdConverter;
import org.xwiki.extension.internal.maven.DefaultMavenExtension;
import org.xwiki.extension.internal.maven.DefaultMavenExtensionDependency;
import org.xwiki.extension.internal.maven.MavenExtension;
import org.xwiki.extension.internal.maven.MavenUtils;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.version.VersionConstraint;
import org.xwiki.extension.version.internal.DefaultVersionConstraint;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class ExtensionConverter
extends AbstractConverter<Extension> {
    private static final String UNKNOWN = "unknown";
    @Inject
    private ExtensionLicenseManager licenseManager;
    @Inject
    private ConverterManager converter;

    protected <G extends Extension> G convertToType(Type targetType, Object value) {
        if (value instanceof Model) {
            return (G)this.convertToExtension((Model)value);
        }
        throw new ConversionException(String.format("Unsupported target type [%s]", targetType));
    }

    private MavenExtension convertToExtension(Model model) {
        ArrayList<DefaultExtensionRepositoryDescriptor> repositories;
        List mavenRepositories;
        String namespacesString;
        String categoryString;
        String featuresString;
        IssueManagement issueManagement;
        Properties properties = (Properties)model.getProperties().clone();
        String version = this.resolveVersion(model.getVersion(), model, false);
        String groupId = this.resolveGroupId(model.getGroupId(), model, false);
        DefaultMavenExtension extension = new DefaultMavenExtension(null, groupId, model.getArtifactId(), version, MavenUtils.packagingToType(model.getPackaging()));
        extension.setName(this.getPropertyString(properties, "name", true, model.getName()));
        extension.setSummary(this.getPropertyString(properties, "summary", true, model.getDescription()));
        extension.setWebsite(this.getPropertyString(properties, "website", true, model.getUrl()));
        for (Developer developer : model.getDevelopers()) {
            URL authorURL = null;
            if (developer.getUrl() != null) {
                try {
                    authorURL = new URL(developer.getUrl());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            extension.addAuthor(new DefaultExtensionAuthor((String)StringUtils.defaultIfBlank((CharSequence)developer.getName(), (CharSequence)developer.getId()), authorURL));
        }
        for (License license : model.getLicenses()) {
            extension.addLicense(this.getExtensionLicense(license));
        }
        Scm scm = model.getScm();
        if (scm != null && (scm.getConnection() != null || scm.getDeveloperConnection() != null || scm.getUrl() != null)) {
            ExtensionScmConnection connection = MavenUtils.toExtensionScmConnection(scm.getConnection());
            ExtensionScmConnection developerConnection = MavenUtils.toExtensionScmConnection(scm.getDeveloperConnection());
            extension.setScm(new DefaultExtensionScm(scm.getUrl(), connection, developerConnection));
        }
        if ((issueManagement = model.getIssueManagement()) != null && issueManagement.getUrl() != null) {
            extension.setIssueManagement(new DefaultExtensionIssueManagement(issueManagement.getSystem(), issueManagement.getUrl()));
        }
        if (StringUtils.isNotBlank((CharSequence)(featuresString = this.getProperty(properties, "features", true)))) {
            featuresString = featuresString.replaceAll("[\r\n]", "");
            Collection features = (Collection)this.converter.convert((Type)new DefaultParameterizedType(null, List.class, new Type[]{String.class}), (Object)featuresString);
            for (String feature : features) {
                extension.addExtensionFeature(ExtensionIdConverter.toExtensionId(feature, extension.getId().getVersion()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(categoryString = this.getProperty(properties, "category", true)))) {
            extension.setCategory(categoryString);
        }
        if (StringUtils.isNotBlank((CharSequence)(namespacesString = this.getProperty(properties, "namespaces", true)))) {
            namespacesString = namespacesString.replaceAll("[\r\n]", "");
            Collection namespaces = (Collection)this.converter.convert((Type)new DefaultParameterizedType(null, List.class, new Type[]{String.class}), (Object)namespacesString);
            extension.setAllowedNamespaces(namespaces);
        }
        if (!(mavenRepositories = model.getRepositories()).isEmpty()) {
            repositories = new ArrayList<DefaultExtensionRepositoryDescriptor>(mavenRepositories.size());
            for (Repository repository : mavenRepositories) {
                try {
                    repositories.add(new DefaultExtensionRepositoryDescriptor(repository.getId(), "maven", new URI(repository.getUrl())));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else {
            repositories = null;
        }
        extension.setRepositories(repositories);
        for (Dependency dependency : model.getDependencies()) {
            if (dependency.isOptional() || dependency.getScope() != null && !dependency.getScope().equals("compile") && !dependency.getScope().equals("runtime")) continue;
            String dependencyGroupId = this.resolveGroupId(dependency.getGroupId(), model, true);
            String dependencyArtifactId = dependency.getArtifactId();
            String dependencyClassifier = dependency.getClassifier();
            String dependencyVersion = this.resolveVersion(dependency.getVersion(), model, true);
            DefaultMavenExtensionDependency extensionDependency = new DefaultMavenExtensionDependency(MavenUtils.toExtensionId(dependencyGroupId, dependencyArtifactId, dependencyClassifier), (VersionConstraint)new DefaultVersionConstraint(dependencyVersion), dependency);
            extension.setRepositories(repositories);
            extension.addDependency(extensionDependency);
        }
        extension.putProperty("maven.Model", model);
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("xwiki.extension.")) continue;
            extension.putProperty(key, entry.getValue());
        }
        return extension;
    }

    private String getProperty(Properties properties, String propertyName, boolean delete) {
        return delete ? (String)properties.remove("xwiki.extension." + propertyName) : properties.getProperty("xwiki.extension." + propertyName);
    }

    private String getPropertyString(Properties properties, String propertyName, boolean delete, String def) {
        return StringUtils.defaultString((String)this.getProperty(properties, propertyName, delete), (String)def);
    }

    private ExtensionLicense getExtensionLicense(License license) {
        if (license.getName() == null) {
            return new ExtensionLicense("noname", null);
        }
        return this.createLicenseByName(license.getName());
    }

    private ExtensionLicense createLicenseByName(String name) {
        ExtensionLicense extensionLicense = this.licenseManager.getLicense(name);
        return extensionLicense != null ? extensionLicense : new ExtensionLicense(name, null);
    }

    private String resolveVersion(String modelVersion, Model mavenModel, boolean dependency) {
        String version = modelVersion;
        if (version == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                version = parent.getVersion();
            }
        } else if (version.startsWith("$")) {
            String propertyName = version.substring(2, version.length() - 1);
            if (propertyName.equals("project.version") || propertyName.equals("pom.version") || propertyName.equals("version")) {
                version = this.resolveVersion(mavenModel.getVersion(), mavenModel, false);
            } else {
                String value = mavenModel.getProperties().getProperty(propertyName);
                if (value != null) {
                    version = value;
                }
            }
        }
        if (version == null) {
            version = UNKNOWN;
        }
        return version;
    }

    private String resolveGroupId(String modelGroupId, Model mavenModel, boolean dependency) {
        String groupId = modelGroupId;
        if (groupId == null) {
            Parent parent;
            if (!dependency && (parent = mavenModel.getParent()) != null) {
                groupId = parent.getGroupId();
            }
        } else if (groupId.startsWith("$")) {
            String propertyName = groupId.substring(2, groupId.length() - 1);
            String value = mavenModel.getProperties().getProperty(propertyName);
            if (value != null) {
                groupId = value;
            }
        }
        if (groupId == null) {
            groupId = UNKNOWN;
        }
        return groupId;
    }
}

