/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.repository.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.repository.internal.SortClauseComparator;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.search.ExtensionQuery;

public final class RepositoryUtils {
    public static final String SEARCH_PATTERN_SUFFIXNPREFIX = ".*";

    private RepositoryUtils() {
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(String pattern, int offset, int nb, Collection<E> extensions) {
        return RepositoryUtils.searchInCollection(pattern, offset, nb, extensions, false);
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(String pattern, int offset, int nb, Collection<E> extensions, boolean forceUnique) {
        ExtensionQuery query = new ExtensionQuery(pattern);
        query.setOffset(offset);
        query.setLimit(nb);
        return RepositoryUtils.searchInCollection(query, extensions, forceUnique);
    }

    public static <E extends Extension> CollectionIterableResult<E> searchInCollection(ExtensionQuery query, Collection<E> extensions, boolean forceUnique) {
        List<E> result = StringUtils.isEmpty((CharSequence)query.getQuery()) ? (extensions instanceof List ? (List<E>)extensions : new ArrayList<E>(extensions)) : RepositoryUtils.filter(query.getQuery(), query.getFilters(), extensions, forceUnique);
        RepositoryUtils.sort(result, query.getSortClauses());
        return RepositoryUtils.getIterableResult(query.getOffset(), query.getLimit(), result);
    }

    public static <E> CollectionIterableResult<E> getIterableResult(int offset, int nb, Collection<E> elements) {
        if (nb == 0 || offset >= elements.size()) {
            return new CollectionIterableResult(elements.size(), offset, Collections.emptyList());
        }
        ArrayList<E> list = elements instanceof List ? (ArrayList<E>)elements : new ArrayList<E>(elements);
        return RepositoryUtils.getIterableResultFromList(offset, nb, list);
    }

    private static <E> CollectionIterableResult<E> getIterableResultFromList(int offset, int nb, List<E> elements) {
        int toIndex;
        int fromIndex = offset;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (nb > 0) {
            toIndex = nb + fromIndex;
            if (toIndex > elements.size()) {
                toIndex = elements.size();
            }
        } else {
            toIndex = elements.size();
        }
        return new CollectionIterableResult<E>(elements.size(), offset, elements.subList(fromIndex, toIndex));
    }

    private static <E extends Extension> List<E> filter(String pattern, Collection<ExtensionQuery.Filter> filters, Collection<E> extensions, boolean forceUnique) {
        ArrayList<Extension> result = new ArrayList<Extension>(extensions.size());
        Pattern patternMatcher = Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + pattern.toLowerCase() + SEARCH_PATTERN_SUFFIXNPREFIX);
        for (Extension extension : extensions) {
            if (!RepositoryUtils.matches(patternMatcher, filters, extension)) continue;
            result.add(extension);
        }
        if (forceUnique && result.size() > 1) {
            result = new ArrayList(new LinkedHashSet(result));
        }
        return result;
    }

    public static boolean matches(Pattern patternMatcher, Collection<ExtensionQuery.Filter> filters, Extension extension) {
        if (RepositoryUtils.matches(patternMatcher, extension.getId().getId(), extension.getDescription(), extension.getSummary(), extension.getName(), extension.getFeatures())) {
            for (ExtensionQuery.Filter filter : filters) {
                if (RepositoryUtils.matches(filter, extension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean matches(ExtensionQuery.Filter filter, Extension extension) {
        Object value = extension.get(filter.getField());
        if (value != null) {
            return RepositoryUtils.matches(filter, value);
        }
        return true;
    }

    public static boolean matches(ExtensionQuery.Filter filter, Object element) {
        Pattern patternMatcher;
        String elementValue;
        String filterValue = filter.getValue() != null ? String.valueOf(filter.getValue()) : null;
        String string = elementValue = element != null ? String.valueOf(element) : null;
        return filter.getComparison() == ExtensionQuery.COMPARISON.MATCH ? RepositoryUtils.matches(patternMatcher = RepositoryUtils.createPatternMatcher(filterValue), (Object)filterValue) : filter.getComparison() == ExtensionQuery.COMPARISON.EQUAL && elementValue != null && filterValue.toLowerCase().equals(elementValue.toLowerCase());
    }

    public static boolean matches(Pattern patternMatcher, Object ... elements) {
        if (patternMatcher == null) {
            return true;
        }
        for (Object element : elements) {
            if (!RepositoryUtils.matches(patternMatcher, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Pattern patternMatcher, Object element) {
        return element != null && patternMatcher.matcher(element.toString().toLowerCase()).matches();
    }

    public static Pattern createPatternMatcher(String pattern) {
        return StringUtils.isEmpty((CharSequence)pattern) ? null : Pattern.compile(SEARCH_PATTERN_SUFFIXNPREFIX + Pattern.quote(pattern.toLowerCase()) + SEARCH_PATTERN_SUFFIXNPREFIX);
    }

    public static void sort(List<? extends Extension> extensions, Collection<ExtensionQuery.SortClause> sortClauses) {
        Collections.sort(extensions, new SortClauseComparator(sortClauses));
    }
}

