/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.safe;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;

@Component
@Singleton
public class DefaultScriptSafeProvider
implements ScriptSafeProvider {
    @Inject
    private ComponentManager component;
    @Inject
    private Logger logger;

    public Object get(Object unsafe) {
        if (unsafe == null) {
            return null;
        }
        Object safe = this.get(unsafe, Arrays.asList(unsafe.getClass()));
        if (safe == null) {
            safe = unsafe;
        }
        return safe;
    }

    private Object get(Object unsafe, List<Type> types) {
        Object safe;
        for (Type type : types) {
            safe = this.get(unsafe, type);
            if (safe == null) continue;
            return safe;
        }
        for (Type type : types) {
            safe = this.get(unsafe, ReflectionUtils.getDirectTypes((Type)type));
            if (safe == null) continue;
            return safe;
        }
        return null;
    }

    private Object get(Object unsafe, Type type) {
        DefaultParameterizedType completeRole = new DefaultParameterizedType(null, ScriptSafeProvider.class, new Type[]{type});
        if (this.component.hasComponent((Type)completeRole)) {
            try {
                ScriptSafeProvider provider = (ScriptSafeProvider)this.component.getInstance((Type)completeRole);
                return provider.get(unsafe);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to load safe provider for complete type [{}]", (Object)type, (Object)e);
            }
        } else if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            DefaultParameterizedType rawRole = new DefaultParameterizedType(null, ScriptSafeProvider.class, new Type[]{rawType});
            this.logger.debug("Could not find any safe provider for type [{}]. Trying with [{}]", (Object)type, (Object)rawType);
            if (this.component.hasComponent((Type)rawRole)) {
                try {
                    ScriptSafeProvider provider = (ScriptSafeProvider)this.component.getInstance((Type)rawRole);
                    return provider.get(unsafe);
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Failed to load safe provider for raw type [{}]", (Object)rawType, (Object)e);
                }
            }
        }
        return null;
    }
}

